/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import com.novosec.pkix.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public class PKIStatusInfo
implements DEREncodable {
    DERInteger status;
    PKIFreeText statusString;
    DERBitString failInfo;

    public static PKIStatusInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return PKIStatusInfo.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static PKIStatusInfo getInstance(Object obj) {
        if (obj instanceof PKIStatusInfo) {
            return (PKIStatusInfo)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new PKIStatusInfo((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public PKIStatusInfo(ASN1Sequence seq) {
        this.status = DERInteger.getInstance((Object)seq.getObjectAt(0));
        this.statusString = null;
        this.failInfo = null;
        if (seq.size() > 2) {
            this.statusString = PKIFreeText.getInstance(seq.getObjectAt(1));
            this.failInfo = DERBitString.getInstance((Object)seq.getObjectAt(2));
        } else if (seq.size() > 1) {
            DEREncodable obj = seq.getObjectAt(1);
            if (obj instanceof ASN1Sequence) {
                this.statusString = PKIFreeText.getInstance(obj);
            } else {
                this.failInfo = DERBitString.getInstance((Object)obj);
            }
        }
    }

    public PKIStatusInfo(DERInteger status) {
        this.status = status;
    }

    public DERInteger getStatus() {
        return this.status;
    }

    public PKIFreeText getStatusString() {
        return this.statusString;
    }

    public void setStatusString(PKIFreeText statusString) {
        this.statusString = statusString;
    }

    public DERBitString getFailInfo() {
        return this.failInfo;
    }

    public void setFailInfo(DERBitString failInfo) {
        this.failInfo = failInfo;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.status);
        if (this.statusString != null) {
            v.add((DEREncodable)this.statusString);
        }
        if (this.failInfo != null) {
            v.add((DEREncodable)this.failInfo);
        }
        return new DERSequence(v);
    }

    public String toString() {
        String s = "PKIStatusInfo: (status = " + this.getStatus();
        if (this.getStatusString() != null) {
            s = s + ", statusString: " + this.getStatusString();
        }
        if (this.getFailInfo() != null) {
            s = s + ", failInfo: " + this.getFailInfo();
        }
        s = s + ")";
        return s;
    }
}

