/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import com.novosec.pkix.asn1.cmp.CertifiedKeyPair;
import com.novosec.pkix.asn1.cmp.PKIStatusInfo;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.X509CertificateStructure;

public class KeyRecRepContent
implements DEREncodable {
    PKIStatusInfo status;
    X509CertificateStructure newSigCert;
    Vector caCerts = new Vector();
    Vector keyPairHists = new Vector();

    public static KeyRecRepContent getInstance(ASN1TaggedObject obj, boolean explicit) {
        return KeyRecRepContent.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static KeyRecRepContent getInstance(Object obj) {
        if (obj instanceof KeyRecRepContent) {
            return (KeyRecRepContent)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new KeyRecRepContent((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public KeyRecRepContent(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.status = PKIStatusInfo.getInstance(e.nextElement());
        block5: while (e.hasMoreElements()) {
            ASN1TaggedObject tagObj = (ASN1TaggedObject)e.nextElement();
            switch (tagObj.getTagNo()) {
                case 0: {
                    this.newSigCert = X509CertificateStructure.getInstance((Object)tagObj.getObject());
                    break;
                }
                case 1: {
                    int i;
                    ASN1Sequence s = (ASN1Sequence)tagObj.getObject();
                    for (i = 0; i < s.size(); ++i) {
                        this.caCerts.addElement(X509CertificateStructure.getInstance((Object)s.getObjectAt(i)));
                    }
                    continue block5;
                }
                case 2: {
                    int i;
                    ASN1Sequence s = (ASN1Sequence)tagObj.getObject();
                    for (i = 0; i < s.size(); ++i) {
                        this.keyPairHists.addElement(CertifiedKeyPair.getInstance(s.getObjectAt(i)));
                    }
                    break;
                }
            }
        }
    }

    public KeyRecRepContent(PKIStatusInfo status) {
        this.status = status;
    }

    public PKIStatusInfo getStatus() {
        return this.status;
    }

    public X509CertificateStructure getNewSigCert() {
        return this.newSigCert;
    }

    public void setNewSigCert(X509CertificateStructure newSigCert) {
        this.newSigCert = newSigCert;
    }

    public void addCaCerts(X509CertificateStructure caCert) {
        this.caCerts.addElement(caCert);
    }

    public X509CertificateStructure getCaCerts(int nr) {
        if (nr < this.caCerts.size()) {
            return (X509CertificateStructure)this.caCerts.elementAt(nr);
        }
        return null;
    }

    public void addKeyPairHist(CertifiedKeyPair keyPairHist) {
        this.keyPairHists.addElement(keyPairHist);
    }

    public CertifiedKeyPair getKeyPairHist(int nr) {
        if (nr < this.keyPairHists.size()) {
            return (CertifiedKeyPair)this.keyPairHists.elementAt(nr);
        }
        return null;
    }

    public DERObject getDERObject() {
        int i;
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.status);
        if (this.newSigCert != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 0, (DEREncodable)this.newSigCert));
        }
        if (this.caCerts.size() > 0) {
            ASN1EncodableVector cacv = new ASN1EncodableVector();
            for (i = 0; i < this.caCerts.size(); ++i) {
                cacv.add((DEREncodable)((X509CertificateStructure)this.caCerts.elementAt(i)));
            }
            v.add((DEREncodable)new DERTaggedObject(true, 1, (DEREncodable)new DERSequence(cacv)));
        }
        if (this.keyPairHists.size() > 0) {
            ASN1EncodableVector keyphv = new ASN1EncodableVector();
            for (i = 0; i < this.keyPairHists.size(); ++i) {
                keyphv.add((DEREncodable)((CertifiedKeyPair)this.keyPairHists.elementAt(i)));
            }
            v.add((DEREncodable)new DERTaggedObject(true, 2, (DEREncodable)new DERSequence(keyphv)));
        }
        return new DERSequence(v);
    }

    public String toString() {
        int i;
        String s = "CertifiedKeyPair: ( status: " + this.getStatus() + ", ";
        if (this.getNewSigCert() != null) {
            s = s + "newSigCert: " + this.getNewSigCert() + ", ";
        }
        if (this.caCerts.size() > 0) {
            s = s + "caCerts: (";
            for (i = 0; i < this.caCerts.size(); ++i) {
                s = s + (X509CertificateStructure)this.caCerts.elementAt(i);
            }
            s = s + "), ";
        }
        if (this.keyPairHists.size() > 0) {
            s = s + "keyPairHist: (";
            for (i = 0; i < this.caCerts.size(); ++i) {
                s = s + (CertifiedKeyPair)this.keyPairHists.elementAt(i);
            }
            s = s + ")";
        }
        s = s + ")";
        return s;
    }
}

