/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import com.novosec.pkix.asn1.cmp.PKIFreeText;
import com.novosec.pkix.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public class ErrorMsgContent
implements DEREncodable {
    PKIStatusInfo pKIStatusInfo;
    DERInteger errorCode;
    PKIFreeText errorDetails;

    public static ErrorMsgContent getInstance(ASN1TaggedObject obj, boolean explicit) {
        return ErrorMsgContent.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static ErrorMsgContent getInstance(Object obj) {
        if (obj instanceof ErrorMsgContent) {
            return (ErrorMsgContent)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new ErrorMsgContent((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public ErrorMsgContent(ASN1Sequence seq) {
        this.pKIStatusInfo = PKIStatusInfo.getInstance(seq.getObjectAt(0));
        this.errorCode = null;
        this.errorDetails = null;
        if (seq.size() > 2) {
            this.errorCode = DERInteger.getInstance((Object)seq.getObjectAt(1));
            this.errorDetails = PKIFreeText.getInstance(seq.getObjectAt(2));
        } else if (seq.size() > 1) {
            DEREncodable obj = seq.getObjectAt(1);
            if (obj instanceof ASN1Sequence) {
                this.errorDetails = PKIFreeText.getInstance(obj);
            } else {
                this.errorCode = DERInteger.getInstance((Object)obj);
            }
        }
    }

    public ErrorMsgContent(PKIStatusInfo pKIstatusInfo) {
        this.pKIStatusInfo = pKIstatusInfo;
        this.errorCode = null;
        this.errorDetails = null;
    }

    public PKIStatusInfo getPKIStatus() {
        return this.pKIStatusInfo;
    }

    public DERInteger getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(DERInteger errorCode) {
        this.errorCode = errorCode;
    }

    public PKIFreeText getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(PKIFreeText errorDetails) {
        this.errorDetails = errorDetails;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.pKIStatusInfo);
        if (this.errorCode != null) {
            v.add((DEREncodable)this.errorCode);
        }
        if (this.errorDetails != null) {
            v.add((DEREncodable)this.errorDetails);
        }
        return new DERSequence(v);
    }

    public String toString() {
        String s = "ErrorMsgContent: (pKIStatus = " + this.getPKIStatus() + ", ";
        if (this.getErrorCode() != null) {
            s = s + "errorCode = " + this.getErrorCode() + ", ";
        }
        if (this.getErrorDetails() != null) {
            s = s + "errorDetails = " + this.getErrorDetails();
        }
        s = s + ")";
        return s;
    }
}

