/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support.impl;

import java.util.Set;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.x509.PKIXTrustEngine;
import org.opensaml.security.x509.PKIXTrustEvaluator;
import org.opensaml.security.x509.PKIXValidationInformation;
import org.opensaml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.impl.BasicX509CredentialNameEvaluator;
import org.opensaml.security.x509.impl.CertPathPKIXTrustEvaluator;
import org.opensaml.security.x509.impl.X509CredentialNameEvaluator;
import org.opensaml.xmlsec.crypto.XMLSigningUtil;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.impl.BaseSignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIXSignatureTrustEngine
extends BaseSignatureTrustEngine<Pair<Set<String>, Iterable<PKIXValidationInformation>>>
implements PKIXTrustEngine<Signature> {
    private final Logger log = LoggerFactory.getLogger(PKIXSignatureTrustEngine.class);
    private PKIXValidationInformationResolver pkixResolver;
    private PKIXTrustEvaluator pkixTrustEvaluator;
    private X509CredentialNameEvaluator credNameEvaluator;

    public PKIXSignatureTrustEngine(PKIXValidationInformationResolver resolver, KeyInfoCredentialResolver keyInfoResolver) {
        super(keyInfoResolver);
        if (resolver == null) {
            throw new IllegalArgumentException("PKIX trust information resolver may not be null");
        }
        this.pkixResolver = resolver;
        this.pkixTrustEvaluator = new CertPathPKIXTrustEvaluator();
        this.credNameEvaluator = new BasicX509CredentialNameEvaluator();
    }

    public PKIXSignatureTrustEngine(PKIXValidationInformationResolver resolver, KeyInfoCredentialResolver keyInfoResolver, PKIXTrustEvaluator pkixEvaluator, X509CredentialNameEvaluator nameEvaluator) {
        super(keyInfoResolver);
        if (resolver == null) {
            throw new IllegalArgumentException("PKIX trust information resolver may not be null");
        }
        this.pkixResolver = resolver;
        if (pkixEvaluator == null) {
            throw new IllegalArgumentException("PKIX trust evaluator may not be null");
        }
        this.pkixTrustEvaluator = pkixEvaluator;
        this.credNameEvaluator = nameEvaluator;
    }

    public PKIXTrustEvaluator getPKIXTrustEvaluator() {
        return this.pkixTrustEvaluator;
    }

    public X509CredentialNameEvaluator getX509CredentialNameEvaluator() {
        return this.credNameEvaluator;
    }

    public PKIXValidationInformationResolver getPKIXResolver() {
        return this.pkixResolver;
    }

    @Override
    public boolean validate(Signature signature, CriteriaSet trustBasisCriteria) throws SecurityException {
        this.checkParams(signature, trustBasisCriteria);
        Pair<Set<String>, Iterable<PKIXValidationInformation>> validationPair = this.resolveValidationInfo(trustBasisCriteria);
        if (this.validate(signature, validationPair)) {
            return true;
        }
        this.log.debug("PKIX validation of signature failed, unable to resolve valid and trusted signing key");
        return false;
    }

    public boolean validate(byte[] signature, byte[] content, String algorithmURI, CriteriaSet trustBasisCriteria, Credential candidateCredential) throws SecurityException {
        if (candidateCredential == null || CredentialSupport.extractVerificationKey((Credential)candidateCredential) == null) {
            this.log.debug("Candidate credential was either not supplied or did not contain verification key");
            this.log.debug("PKIX trust engine requires supplied key, skipping PKIX trust evaluation");
            return false;
        }
        this.checkParamsRaw(signature, content, algorithmURI, trustBasisCriteria);
        Pair<Set<String>, Iterable<PKIXValidationInformation>> validationPair = this.resolveValidationInfo(trustBasisCriteria);
        if (XMLSigningUtil.verifyWithURI((Credential)candidateCredential, (String)algorithmURI, (byte[])signature, (byte[])content)) {
            this.log.debug("Successfully verified raw signature using supplied candidate credential");
            this.log.debug("Attempting to establish trust of supplied candidate credential");
            if (this.evaluateTrust(candidateCredential, validationPair)) {
                this.log.debug("Successfully established trust of supplied candidate credential");
                return true;
            }
            this.log.debug("Failed to establish trust of supplied candidate credential");
        } else {
            this.log.debug("Cryptographic verification of raw signature failed with candidate credential");
        }
        this.log.debug("PKIX validation of raw signature failed, unable to establish trust of supplied verification credential");
        return false;
    }

    @Override
    protected boolean evaluateTrust(Credential untrustedCredential, Pair<Set<String>, Iterable<PKIXValidationInformation>> validationPair) throws SecurityException {
        if (!(untrustedCredential instanceof X509Credential)) {
            this.log.debug("Can not evaluate trust of non-X509Credential");
            return false;
        }
        X509Credential untrustedX509Credential = (X509Credential)untrustedCredential;
        Set trustedNames = (Set)validationPair.getFirst();
        Iterable validationInfoSet = (Iterable)validationPair.getSecond();
        if (!this.checkNames(trustedNames, untrustedX509Credential)) {
            this.log.debug("Evaluation of credential against trusted names failed. Aborting PKIX validation");
            return false;
        }
        for (PKIXValidationInformation validationInfo : validationInfoSet) {
            try {
                if (!this.pkixTrustEvaluator.validate(validationInfo, untrustedX509Credential)) continue;
                this.log.debug("Signature trust established via PKIX validation of signing credential");
                return true;
            }
            catch (SecurityException e) {
                this.log.debug("Error performing PKIX validation on untrusted credential", (Throwable)e);
            }
        }
        this.log.debug("Signature trust could not be established via PKIX validation of signing credential");
        return false;
    }

    protected Pair<Set<String>, Iterable<PKIXValidationInformation>> resolveValidationInfo(CriteriaSet trustBasisCriteria) throws SecurityException {
        Iterable validationInfoSet;
        Set trustedNames = null;
        if (this.pkixResolver.supportsTrustedNameResolution()) {
            try {
                trustedNames = this.pkixResolver.resolveTrustedNames(trustBasisCriteria);
            }
            catch (UnsupportedOperationException e) {
                throw new SecurityException("Error resolving trusted names", (Exception)e);
            }
            catch (ResolverException e) {
                throw new SecurityException("Error resolving trusted names", (Exception)((Object)e));
            }
        } else {
            this.log.debug("PKIX resolver does not support resolution of trusted names, skipping name checking");
        }
        try {
            validationInfoSet = this.pkixResolver.resolve((Object)trustBasisCriteria);
        }
        catch (ResolverException e) {
            throw new SecurityException("Error resolving trusted PKIX validation information", (Exception)((Object)e));
        }
        Pair validationPair = new Pair((Object)trustedNames, (Object)validationInfoSet);
        return validationPair;
    }

    protected boolean checkNames(Set<String> trustedNames, X509Credential untrustedCredential) throws SecurityException {
        if (this.credNameEvaluator == null) {
            this.log.debug("No credential name evaluator was available, skipping trusted name evaluation");
            return true;
        }
        return this.credNameEvaluator.evaluate(untrustedCredential, trustedNames);
    }
}

