/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support.impl;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingSignatureTrustEngine
implements SignatureTrustEngine {
    private final Logger log = LoggerFactory.getLogger(ChainingSignatureTrustEngine.class);
    private List<SignatureTrustEngine> engines = new ArrayList<SignatureTrustEngine>();

    public List<SignatureTrustEngine> getChain() {
        return this.engines;
    }

    public KeyInfoCredentialResolver getKeyInfoResolver() {
        return null;
    }

    public boolean validate(Signature token, CriteriaSet trustBasisCriteria) throws SecurityException {
        for (SignatureTrustEngine engine : this.engines) {
            if (!engine.validate((Object)token, trustBasisCriteria)) continue;
            this.log.debug("Signature was trusted by chain member: {}", (Object)engine.getClass().getName());
            return true;
        }
        return false;
    }

    public boolean validate(byte[] signature, byte[] content, String algorithmURI, CriteriaSet trustBasisCriteria, Credential candidateCredential) throws SecurityException {
        for (SignatureTrustEngine engine : this.engines) {
            if (!engine.validate(signature, content, algorithmURI, trustBasisCriteria, candidateCredential)) continue;
            this.log.debug("Signature was trusted by chain member: {}", (Object)engine.getClass().getName());
            return true;
        }
        return false;
    }
}

