/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support.impl;

import com.google.common.base.Strings;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCriterion;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSignatureTrustEngine<TrustBasisType>
implements SignatureTrustEngine {
    private final Logger log = LoggerFactory.getLogger(BaseSignatureTrustEngine.class);
    private KeyInfoCredentialResolver keyInfoCredentialResolver;

    public BaseSignatureTrustEngine(KeyInfoCredentialResolver keyInfoResolver) {
        if (keyInfoResolver == null) {
            throw new IllegalArgumentException("KeyInfo credential resolver may not be null");
        }
        this.keyInfoCredentialResolver = keyInfoResolver;
    }

    public KeyInfoCredentialResolver getKeyInfoResolver() {
        return this.keyInfoCredentialResolver;
    }

    protected boolean validate(Signature signature, TrustBasisType trustBasis) throws SecurityException {
        this.log.debug("Attempting to verify signature and establish trust using KeyInfo-derived credentials");
        if (signature.getKeyInfo() != null) {
            KeyInfoCriterion keyInfoCriteria = new KeyInfoCriterion(signature.getKeyInfo());
            CriteriaSet keyInfoCriteriaSet = new CriteriaSet(new Criterion[]{keyInfoCriteria});
            try {
                for (Credential kiCred : this.getKeyInfoResolver().resolve((Object)keyInfoCriteriaSet)) {
                    if (!this.verifySignature(signature, kiCred)) continue;
                    this.log.debug("Successfully verified signature using KeyInfo-derived credential");
                    this.log.debug("Attempting to establish trust of KeyInfo-derived credential");
                    if (this.evaluateTrust(kiCred, trustBasis)) {
                        this.log.debug("Successfully established trust of KeyInfo-derived credential");
                        return true;
                    }
                    this.log.debug("Failed to establish trust of KeyInfo-derived credential");
                }
            }
            catch (ResolverException e) {
                throw new SecurityException("Error resolving KeyInfo from KeyInfoResolver", (Exception)((Object)e));
            }
        } else {
            this.log.debug("Signature contained no KeyInfo element, could not resolve verification credentials");
        }
        this.log.debug("Failed to verify signature and/or establish trust using any KeyInfo-derived credentials");
        return false;
    }

    protected abstract boolean evaluateTrust(Credential var1, TrustBasisType var2) throws SecurityException;

    protected boolean verifySignature(Signature signature, Credential credential) {
        SignatureValidator validator = new SignatureValidator(credential);
        try {
            validator.validate(signature);
        }
        catch (SignatureException e) {
            this.log.debug("Signature validation using candidate validation credential failed", (Throwable)e);
            return false;
        }
        this.log.debug("Signature validation using candidate credential was successful");
        return true;
    }

    protected void checkParams(Signature signature, CriteriaSet trustBasisCriteria) throws SecurityException {
        if (signature == null) {
            throw new SecurityException("Signature was null");
        }
        if (trustBasisCriteria == null) {
            throw new SecurityException("Trust basis criteria set was null");
        }
        if (trustBasisCriteria.isEmpty()) {
            throw new SecurityException("Trust basis criteria set was empty");
        }
    }

    protected void checkParamsRaw(byte[] signature, byte[] content, String algorithmURI, CriteriaSet trustBasisCriteria) throws SecurityException {
        if (signature == null || signature.length == 0) {
            throw new SecurityException("Signature byte array was null or empty");
        }
        if (content == null || content.length == 0) {
            throw new SecurityException("Content byte array was null or empty");
        }
        if (Strings.isNullOrEmpty((String)algorithmURI)) {
            throw new SecurityException("Signature algorithm was null or empty");
        }
        if (trustBasisCriteria == null) {
            throw new SecurityException("Trust basis criteria set was null");
        }
        if (trustBasisCriteria.isEmpty()) {
            throw new SecurityException("Trust basis criteria set was empty");
        }
    }
}

