/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support;

import java.security.Key;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.impl.SignatureImpl;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureValidator {
    private final Logger log = LoggerFactory.getLogger(SignatureValidator.class);
    private Credential validationCredential;

    public SignatureValidator(Credential validatingCredential) {
        this.validationCredential = validatingCredential;
    }

    public void validate(Signature signature) throws SignatureException {
        this.log.debug("Attempting to validate signature using key from supplied credential");
        XMLSignature xmlSig = this.buildSignature(signature);
        Key validationKey = CredentialSupport.extractVerificationKey((Credential)this.validationCredential);
        if (validationKey == null) {
            this.log.debug("Supplied credential contained no key suitable for signature validation");
            throw new SignatureException("No key available to validate signature");
        }
        this.log.debug("Validating signature with signature algorithm URI: {}", (Object)signature.getSignatureAlgorithm());
        this.log.debug("Validation credential key algorithm '{}', key instance class '{}'", (Object)validationKey.getAlgorithm(), (Object)validationKey.getClass().getName());
        try {
            if (xmlSig.checkSignatureValue(validationKey)) {
                this.log.debug("Signature validated with key from supplied credential");
                return;
            }
        }
        catch (XMLSignatureException e) {
            throw new SignatureException("Unable to evaluate key against signature", (Exception)((Object)e));
        }
        this.log.debug("Signature did not validate against the credential's key");
        throw new SignatureException("Signature did not validate against the credential's key");
    }

    protected XMLSignature buildSignature(Signature signature) {
        this.log.debug("Creating XMLSignature object");
        return ((SignatureImpl)signature).getXMLSignature();
    }
}

