/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl;

import com.google.common.base.Strings;
import java.security.PublicKey;
import java.util.List;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.impl.KeyInfoBuilder;

public class BasicKeyInfoGeneratorFactory
implements KeyInfoGeneratorFactory {
    private BasicOptions options = this.newOptions();

    public Class<? extends Credential> getCredentialType() {
        return Credential.class;
    }

    public boolean handles(Credential credential) {
        return true;
    }

    public KeyInfoGenerator newInstance() {
        BasicOptions newOptions = this.options.clone();
        return new BasicKeyInfoGenerator(newOptions);
    }

    public boolean emitEntityIDAsKeyName() {
        return this.options.emitEntityIDAsKeyName;
    }

    public void setEmitEntityIDAsKeyName(boolean newValue) {
        this.options.emitEntityIDAsKeyName = newValue;
    }

    public boolean emitKeyNames() {
        return this.options.emitKeyNames;
    }

    public void setEmitKeyNames(boolean newValue) {
        this.options.emitKeyNames = newValue;
    }

    public boolean emitPublicKeyValue() {
        return this.options.emitPublicKeyValue;
    }

    public void setEmitPublicKeyValue(boolean newValue) {
        this.options.emitPublicKeyValue = newValue;
    }

    protected BasicOptions newOptions() {
        return new BasicOptions();
    }

    protected BasicOptions getOptions() {
        return this.options;
    }

    protected class BasicOptions
    implements Cloneable {
        private boolean emitKeyNames;
        private boolean emitEntityIDAsKeyName;
        private boolean emitPublicKeyValue;

        protected BasicOptions() {
        }

        protected BasicOptions clone() {
            try {
                return (BasicOptions)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    public class BasicKeyInfoGenerator
    implements KeyInfoGenerator {
        private BasicOptions options;
        private KeyInfoBuilder keyInfoBuilder;

        protected BasicKeyInfoGenerator(BasicOptions newOptions) {
            this.options = newOptions;
            this.keyInfoBuilder = (KeyInfoBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(KeyInfo.DEFAULT_ELEMENT_NAME);
        }

        public KeyInfo generate(Credential credential) throws SecurityException {
            KeyInfo keyInfo = this.keyInfoBuilder.buildObject();
            this.processKeyNames(keyInfo, credential);
            this.processEntityID(keyInfo, credential);
            this.processPublicKey(keyInfo, credential);
            List children = keyInfo.getOrderedChildren();
            if (children != null && children.size() > 0) {
                return keyInfo;
            }
            return null;
        }

        protected void processKeyNames(KeyInfo keyInfo, Credential credential) {
            if (this.options.emitKeyNames) {
                for (String keyNameValue : credential.getKeyNames()) {
                    if (Strings.isNullOrEmpty((String)keyNameValue)) continue;
                    KeyInfoSupport.addKeyName((KeyInfo)keyInfo, (String)keyNameValue);
                }
            }
        }

        protected void processEntityID(KeyInfo keyInfo, Credential credential) {
            String keyNameValue;
            if (this.options.emitEntityIDAsKeyName && !Strings.isNullOrEmpty((String)(keyNameValue = credential.getEntityId()))) {
                KeyInfoSupport.addKeyName((KeyInfo)keyInfo, (String)keyNameValue);
            }
        }

        protected void processPublicKey(KeyInfo keyInfo, Credential credential) {
            if (this.options.emitPublicKeyValue && credential.getPublicKey() != null) {
                KeyInfoSupport.addPublicKey((KeyInfo)keyInfo, (PublicKey)credential.getPublicKey());
            }
        }
    }
}

