/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.soap11.decoder.http;

import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.soap.soap11.decoder.SOAP11Decoder;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPSOAP11Decoder
extends SOAP11Decoder {
    private final Logger log = LoggerFactory.getLogger(HTTPSOAP11Decoder.class);

    public HTTPSOAP11Decoder() {
    }

    public HTTPSOAP11Decoder(ParserPool pool) {
        super(pool);
    }

    @Override
    protected void doDecode(MessageContext messageContext) throws MessageDecodingException {
        if (!(messageContext.getInboundMessageTransport() instanceof HTTPInTransport)) {
            this.log.error("Invalid inbound message transport type, this decoder only support HTTPInTransport");
            throw new MessageDecodingException("Invalid inbound message transport type, this decoder only support HTTPInTransport");
        }
        HTTPInTransport inTransport = (HTTPInTransport)messageContext.getInboundMessageTransport();
        if (!inTransport.getHTTPMethod().equalsIgnoreCase("POST")) {
            throw new MessageDecodingException("This message deocoder only supports the HTTP POST method");
        }
        super.doDecode(messageContext);
    }
}

