/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.soap11.decoder;

import java.util.List;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.security.SecurityException;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.handler.BaseHandlerChainAwareMessageDecoder;
import org.opensaml.ws.transport.InTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOAP11Decoder
extends BaseHandlerChainAwareMessageDecoder {
    private final Logger log = LoggerFactory.getLogger(SOAP11Decoder.class);

    public SOAP11Decoder() {
    }

    public SOAP11Decoder(ParserPool pool) {
        super(pool);
    }

    protected void doDecode(MessageContext messageContext) throws MessageDecodingException {
        InTransport inTransport = messageContext.getInboundMessageTransport();
        this.log.debug("Unmarshalling SOAP message");
        Envelope soapMessage = (Envelope)this.unmarshallMessage(inTransport.getIncomingStream());
        messageContext.setInboundMessage((XMLObject)soapMessage);
    }

    public void decode(MessageContext messageContext) throws MessageDecodingException, SecurityException {
        super.decode(messageContext);
    }

    private void checkUnderstoodSOAPHeaders(MessageContext messageContext) throws MessageDecodingException {
        Envelope envelope = (Envelope)messageContext.getInboundMessage();
        Header soapHeader = envelope.getHeader();
        if (soapHeader == null) {
            this.log.debug("SOAP Envelope contained no Header");
            return;
        }
        List headers = soapHeader.getUnknownXMLObjects();
        if (headers == null || headers.isEmpty()) {
            this.log.debug("SOAP Envelope header list was either null or empty");
            return;
        }
        for (XMLObject header : headers) {
        }
    }
}

