/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509;

import javax.security.auth.x500.X500Principal;
import org.opensaml.security.x509.X500DNHandler;

public class InternalX500DNHandler
implements X500DNHandler {
    @Override
    public byte[] getEncoded(X500Principal principal) {
        if (principal == null) {
            throw new NullPointerException("X500Principal may not be null");
        }
        return principal.getEncoded();
    }

    @Override
    public String getName(X500Principal principal) {
        if (principal == null) {
            throw new NullPointerException("X500Principal may not be null");
        }
        return principal.getName();
    }

    @Override
    public String getName(X500Principal principal, String format) {
        if (principal == null) {
            throw new NullPointerException("X500Principal may not be null");
        }
        return principal.getName(format);
    }

    @Override
    public X500Principal parse(String name) {
        if (name == null) {
            throw new NullPointerException("X.500 name string may not be null");
        }
        return new X500Principal(name);
    }

    @Override
    public X500Principal parse(byte[] name) {
        if (name == null) {
            throw new NullPointerException("X.500 DER-encoded name may not be null");
        }
        return new X500Principal(name);
    }

    @Override
    public X500DNHandler clone() {
        return new InternalX500DNHandler();
    }
}

