/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.ldaptive.ssl.CredentialConfig;
import org.ldaptive.ssl.KeyStoreCredentialReader;
import org.ldaptive.ssl.KeyStoreSSLContextInitializer;
import org.ldaptive.ssl.SSLContextInitializer;

public class KeyStoreCredentialConfig
implements CredentialConfig {
    private final KeyStoreCredentialReader keyStoreReader = new KeyStoreCredentialReader();
    private String trustStore;
    private String trustStorePassword;
    private String trustStoreType;
    private String keyStore;
    private String keyStorePassword;
    private String keyStoreType;

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String name) {
        this.trustStore = name;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String password) {
        this.trustStorePassword = password;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String type) {
        this.trustStoreType = type;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String name) {
        this.keyStore = name;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String password) {
        this.keyStorePassword = password;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String type) {
        this.keyStoreType = type;
    }

    @Override
    public SSLContextInitializer createSSLContextInitializer() throws GeneralSecurityException {
        KeyStoreSSLContextInitializer sslInit = new KeyStoreSSLContextInitializer();
        try {
            if (this.trustStore != null) {
                sslInit.setTrustKeystore((KeyStore)this.keyStoreReader.read(this.trustStore, this.trustStorePassword, this.trustStoreType));
            }
            if (this.keyStore != null) {
                sslInit.setAuthenticationKeystore((KeyStore)this.keyStoreReader.read(this.keyStore, this.keyStorePassword, this.keyStoreType));
                sslInit.setAuthenticationPassword(this.keyStorePassword != null ? this.keyStorePassword.toCharArray() : null);
            }
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
        return sslInit;
    }
}

