/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ssl;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTrustManager
implements X509TrustManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final X509TrustManager[] trustManagers;

    public DefaultTrustManager() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            TrustManager[] tm = tmf.getTrustManagers();
            this.trustManagers = new X509TrustManager[tm.length];
            for (int i = 0; i < tm.length; ++i) {
                this.trustManagers[i] = (X509TrustManager)tm[i];
            }
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager tm : this.trustManagers) {
            this.logger.debug("invoking checkClientTrusted invoked for {}", (Object)tm);
            tm.checkClientTrusted(chain, authType);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager tm : this.trustManagers) {
            this.logger.debug("invoking checkServerTrusted invoked for {}", (Object)tm);
            tm.checkServerTrusted(chain, authType);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList issuers = new ArrayList();
        if (this.trustManagers != null) {
            for (X509TrustManager tm : this.trustManagers) {
                this.logger.debug("invoking getAcceptedIssuers invoked for {}", (Object)tm);
                Collections.addAll(issuers, tm.getAcceptedIssuers());
            }
        }
        return issuers.toArray(new X509Certificate[issuers.size()]);
    }
}

