/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.servlets;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchResult;
import org.ldaptive.servlets.AbstractServlet;

public final class AttributeServlet
extends AbstractServlet {
    private static final long serialVersionUID = 3437252581014900696L;

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String attribute = request.getParameter("attr");
        byte[] value = null;
        String content = request.getParameter("content-type");
        if ("octet".equalsIgnoreCase(content)) {
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + attribute + ".bin\"");
        } else {
            response.setContentType("text/plain");
        }
        try {
            LdapAttribute a;
            SearchResult result = this.search(request.getParameter("query"), request.getParameterValues("attrs"));
            LdapEntry e = result.getEntry();
            if (e != null && e.size() > 0 && (a = e.getAttribute(attribute)) != null && a.size() > 0) {
                value = a.getBinaryValue();
            }
            if (value != null) {
                ServletOutputStream out = response.getOutputStream();
                out.write(value);
                out.flush();
                out.close();
            }
        }
        catch (Exception e) {
            this.logger.error("Error performing search", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }
}

