/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.servlets;

import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.SearchExecutor;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.pool.ConnectionPoolType;
import org.ldaptive.pool.PooledConnectionFactory;
import org.ldaptive.props.PooledConnectionFactoryPropertySource;
import org.ldaptive.props.PropertySource;
import org.ldaptive.props.SearchRequestPropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServlet
extends HttpServlet {
    public static final String POOL_TYPE = "poolType";
    private static final long serialVersionUID = -6245486456044663458L;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private PooledConnectionFactory connectionFactory;
    private SearchExecutor searchExecutor;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.searchExecutor = new SearchExecutor();
        SearchRequestPropertySource srSource = new SearchRequestPropertySource((SearchRequest)this.searchExecutor, AbstractServlet.createProperties(config));
        srSource.initialize();
        this.logger.debug("searchExecutor = {}", (Object)this.searchExecutor);
        this.connectionFactory = new PooledConnectionFactory();
        PooledConnectionFactoryPropertySource cfPropSource = new PooledConnectionFactoryPropertySource(this.connectionFactory, AbstractServlet.createProperties(config));
        cfPropSource.setPoolType(ConnectionPoolType.valueOf(this.getInitParameter(POOL_TYPE)));
        cfPropSource.initialize();
        this.logger.debug("connectionFactory = {}", (Object)this.connectionFactory);
    }

    protected static Properties createProperties(ServletConfig config) {
        Properties p = new Properties();
        Enumeration e = config.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.contains(".")) {
                p.setProperty(name, config.getInitParameter(name));
                continue;
            }
            p.setProperty(PropertySource.PropertyDomain.LDAP.value() + name, config.getInitParameter(name));
        }
        return p;
    }

    protected SearchResult search(String query, String[] attrs) throws LdapException {
        SearchResult result = null;
        if (query != null) {
            result = this.searchExecutor.search((ConnectionFactory)this.connectionFactory, query, attrs).getResult();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.connectionFactory.getConnectionPool().close();
        }
        finally {
            super.destroy();
        }
    }
}

