/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.jndi;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.ldaptive.LdapException;
import org.ldaptive.provider.AbstractProviderConnectionFactory;
import org.ldaptive.provider.ConnectionException;
import org.ldaptive.provider.jndi.JndiConnection;
import org.ldaptive.provider.jndi.JndiProviderConfig;
import org.ldaptive.provider.jndi.NamingExceptionUtils;

public class JndiConnectionFactory
extends AbstractProviderConnectionFactory<JndiProviderConfig> {
    private final Map<String, Object> environment;

    public JndiConnectionFactory(String url, JndiProviderConfig config, Map<String, Object> env) {
        super(url, config);
        this.environment = Collections.unmodifiableMap(env);
    }

    protected Map<String, Object> getEnvironment() {
        return this.environment;
    }

    @Override
    protected JndiConnection createInternal(String url) throws LdapException {
        JndiConnection conn;
        Hashtable<String, Object> env = new Hashtable<String, Object>(this.getEnvironment());
        env.put("java.naming.provider.url", url);
        try {
            conn = new JndiConnection(new InitialLdapContext(env, null), (JndiProviderConfig)this.getProviderConfig());
        }
        catch (NamingException e) {
            throw new ConnectionException(e, NamingExceptionUtils.getResultCode(e.getClass()));
        }
        return conn;
    }

    @Override
    public String toString() {
        return String.format("[%s@%d::connectionCount=%s, environment=%s, providerConfig=%s]", this.getClass().getName(), this.hashCode(), this.getConnectionCount(), this.environment, this.getProviderConfig());
    }
}

