/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.ldaptive.control.RequestControl;
import org.ldaptive.control.ResponseControl;
import org.ldaptive.provider.ControlHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlProcessor<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ControlHandler<T> controlHandler;

    public ControlProcessor(ControlHandler<T> handler) {
        this.controlHandler = handler;
    }

    public T[] processRequestControls(RequestControl[] requestControls) {
        if (requestControls == null) {
            return null;
        }
        this.logger.trace("processing request controls: {}", new Object[]{requestControls});
        ArrayList<T> providerCtls = new ArrayList<T>(requestControls.length);
        for (RequestControl c : requestControls) {
            T providerCtl = this.processRequest(c);
            if (providerCtl == null) continue;
            providerCtls.add(providerCtl);
        }
        this.logger.trace("produced provider request controls: {}", providerCtls);
        return !providerCtls.isEmpty() ? providerCtls.toArray((Object[])Array.newInstance(providerCtls.iterator().next().getClass(), providerCtls.size())) : null;
    }

    protected T processRequest(RequestControl ctl) {
        if (ctl == null) {
            return null;
        }
        T providerCtl = this.controlHandler.processRequest(ctl);
        if (providerCtl == null) {
            throw new UnsupportedOperationException("Request control not supported: " + ctl);
        }
        return providerCtl;
    }

    public ResponseControl[] processResponseControls(T[] responseControls) {
        if (responseControls == null) {
            return null;
        }
        this.logger.trace("processing provider response controls: {}", (Object[])responseControls);
        ArrayList<ResponseControl> ctls = new ArrayList<ResponseControl>(responseControls.length);
        for (T c : responseControls) {
            ResponseControl ctl = this.processResponse(c);
            if (ctl == null) continue;
            ctls.add(ctl);
        }
        this.logger.trace("produced response controls: {}", ctls);
        return ctls.toArray(new ResponseControl[ctls.size()]);
    }

    protected ResponseControl processResponse(T providerCtl) {
        if (providerCtl == null) {
            return null;
        }
        ResponseControl ctl = this.controlHandler.processResponse(providerCtl);
        if (ctl == null) {
            throw new UnsupportedOperationException("Response control not supported: " + providerCtl);
        }
        return ctl;
    }
}

