/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.ldaptive.AbstractConfig;
import org.ldaptive.LdapException;
import org.ldaptive.provider.ConnectionException;
import org.ldaptive.provider.ConnectionStrategy;
import org.ldaptive.provider.ProviderConfig;
import org.ldaptive.provider.ProviderConnection;
import org.ldaptive.provider.ProviderConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProviderConnectionFactory<T extends ProviderConfig>
implements ProviderConnectionFactory<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String ldapUrl;
    private final T providerConfig;
    private ConnectionCount connectionCount = new ConnectionCount();

    public AbstractProviderConnectionFactory(String url, T config) {
        if (url == null) {
            throw new IllegalArgumentException("LDAP URL cannot be null");
        }
        this.ldapUrl = url;
        this.providerConfig = config;
        ((AbstractConfig)this.providerConfig).makeImmutable();
    }

    @Override
    public T getProviderConfig() {
        return this.providerConfig;
    }

    protected ConnectionCount getConnectionCount() {
        return this.connectionCount;
    }

    protected void setConnectionCount(ConnectionCount cc) {
        this.connectionCount = cc;
    }

    @Override
    public ProviderConnection create() throws LdapException {
        ConnectionException lastThrown = null;
        String[] urls = this.parseLdapUrl(this.ldapUrl, ((ProviderConfig)this.providerConfig).getConnectionStrategy());
        ProviderConnection conn = null;
        for (String url : urls) {
            try {
                this.logger.trace("[{}] Attempting connection to {} for strategy {}", new Object[]{this.connectionCount, url, ((ProviderConfig)this.providerConfig).getConnectionStrategy()});
                conn = this.createInternal(url);
                this.connectionCount.incrementCount();
                lastThrown = null;
                break;
            }
            catch (ConnectionException e) {
                lastThrown = e;
                this.logger.debug("Error connecting to LDAP URL: {}", (Object)url, (Object)e);
            }
        }
        if (lastThrown != null) {
            throw lastThrown;
        }
        return conn;
    }

    protected abstract ProviderConnection createInternal(String var1) throws LdapException;

    protected String[] parseLdapUrl(String url, ConnectionStrategy strategy) {
        String[] urls = null;
        if (strategy == ConnectionStrategy.DEFAULT) {
            urls = new String[]{url};
        } else if (strategy == ConnectionStrategy.ACTIVE_PASSIVE) {
            List<String> l = this.splitLdapUrl(url);
            urls = l.toArray(new String[l.size()]);
        } else if (strategy == ConnectionStrategy.ROUND_ROBIN) {
            List<String> l = this.splitLdapUrl(url);
            for (int i = 0; i < this.connectionCount.getCount() % l.size(); ++i) {
                l.add(l.remove(0));
            }
            urls = l.toArray(new String[l.size()]);
        } else if (strategy == ConnectionStrategy.RANDOM) {
            List<String> l = this.splitLdapUrl(url);
            Collections.shuffle(l);
            urls = l.toArray(new String[l.size()]);
        }
        return urls;
    }

    private List<String> splitLdapUrl(String url) {
        ArrayList<String> urls = new ArrayList<String>();
        if (url != null) {
            StringTokenizer st = new StringTokenizer(url);
            while (st.hasMoreTokens()) {
                urls.add(st.nextToken());
            }
        } else {
            urls.add(null);
        }
        return urls;
    }

    public String toString() {
        return String.format("[%s@%d::ldapUrl=%s, providerConfig=%s, connectionCount=%s]", this.getClass().getName(), this.hashCode(), this.ldapUrl, this.providerConfig, this.connectionCount);
    }

    private class ConnectionCount {
        private int count;

        private ConnectionCount() {
        }

        public int getCount() {
            return this.count;
        }

        public void incrementCount() {
            ++this.count;
            if (this.count < 0) {
                this.count = 0;
            }
        }

        public String toString() {
            return Integer.toString(this.count);
        }
    }
}

