/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.props;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ldaptive.props.SimplePropertyInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyValueParser {
    private static final Pattern CONFIG_PATTERN = Pattern.compile("([^\\{]+)\\s*\\{(.*)\\}\\s*");
    private static final Pattern PARAMS_ONLY_CONFIG_PATTERN = Pattern.compile("\\s*\\{\\s*(.*)\\s*\\}\\s*");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("([^\\}\\{])+");
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String className;
    private final Map<String, String> properties = new HashMap<String, String>();

    public PropertyValueParser(String config) {
        Matcher matcher = CONFIG_PATTERN.matcher(config);
        if (matcher.matches()) {
            this.className = matcher.group(1).trim();
            String props = matcher.group(2).trim();
            Matcher m = PROPERTY_PATTERN.matcher(props);
            while (m.find()) {
                String input = m.group().trim();
                if (input == null || "".equals(input)) continue;
                String[] s = input.split("=", 2);
                this.properties.put(s[0].trim(), s[1].trim());
            }
        }
    }

    public PropertyValueParser(String config, String clazz) {
        Matcher matcher = PARAMS_ONLY_CONFIG_PATTERN.matcher(config);
        this.className = clazz;
        if (matcher.matches()) {
            String props = matcher.group(1).trim();
            Matcher m = PROPERTY_PATTERN.matcher(props);
            while (m.find()) {
                String input = m.group().trim();
                if (input == null || "".equals(input)) continue;
                String[] s = input.split("=", 2);
                this.properties.put(s[0].trim(), s[1].trim());
            }
        }
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static boolean isConfig(String config) {
        return CONFIG_PATTERN.matcher(config).matches();
    }

    public static boolean isParamsOnlyConfig(String config) {
        return PARAMS_ONLY_CONFIG_PATTERN.matcher(config).matches();
    }

    public Object initializeType() {
        Class<?> c = SimplePropertyInvoker.createClass(this.getClassName());
        Class<?> o = SimplePropertyInvoker.instantiateType(c, this.getClassName());
        this.setProperties(c, o);
        return o;
    }

    protected void setProperties(Class<?> c, Object o) {
        SimplePropertyInvoker invoker = new SimplePropertyInvoker(c);
        for (Map.Entry<String, String> entry : this.getProperties().entrySet()) {
            invoker.setProperty(o, entry.getKey(), entry.getValue());
        }
        if (invoker.getProperties().contains("initialize")) {
            try {
                invoker.setProperty(o, "initialize", null);
            }
            catch (Throwable t) {
                this.logger.debug("Error invoking initialize method", t);
            }
        }
    }
}

