/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import org.ldaptive.CompareOperation;
import org.ldaptive.CompareRequest;
import org.ldaptive.Connection;
import org.ldaptive.LdapAttribute;
import org.ldaptive.pool.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareValidator
implements Validator<Connection> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private CompareRequest compareRequest;

    public CompareValidator() {
        this.compareRequest = new CompareRequest();
        this.compareRequest.setDn("");
        this.compareRequest.setAttribute(new LdapAttribute("objectClass", "top"));
    }

    public CompareValidator(CompareRequest cr) {
        this.compareRequest = cr;
    }

    public CompareRequest getCompareRequest() {
        return this.compareRequest;
    }

    public void setCompareRequest(CompareRequest cr) {
        this.compareRequest = cr;
    }

    @Override
    public boolean validate(Connection c) {
        boolean success = false;
        if (c != null) {
            try {
                CompareOperation compare = new CompareOperation(c);
                success = (Boolean)compare.execute(this.compareRequest).getResult();
            }
            catch (Exception e) {
                this.logger.debug("validation failed for compare request {}", (Object)this.compareRequest, (Object)e);
            }
        }
        return success;
    }
}

