/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import org.ldaptive.pool.Activator;
import org.ldaptive.pool.Passivator;
import org.ldaptive.pool.PoolConfig;
import org.ldaptive.pool.PruneStrategy;
import org.ldaptive.pool.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPool<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PoolConfig poolConfig;
    private Activator<T> activator;
    private Passivator<T> passivator;
    private Validator<T> validator;
    private PruneStrategy pruneStrategy;

    public PoolConfig getPoolConfig() {
        return this.poolConfig;
    }

    public void setPoolConfig(PoolConfig pc) {
        this.logger.trace("setting poolConfig: {}", (Object)pc);
        this.poolConfig = pc;
    }

    public Activator<T> getActivator() {
        return this.activator;
    }

    public void setActivator(Activator<T> a) {
        this.logger.trace("setting activator: {}", a);
        this.activator = a;
    }

    public boolean activate(T t) {
        boolean success;
        if (this.activator == null) {
            success = true;
            this.logger.trace("no activator configured");
        } else {
            success = this.activator.activate(t);
            this.logger.trace("activation for {} = {}", t, (Object)success);
        }
        return success;
    }

    public Passivator<T> getPassivator() {
        return this.passivator;
    }

    public void setPassivator(Passivator<T> p) {
        this.logger.trace("setting passivator: {}", p);
        this.passivator = p;
    }

    public boolean passivate(T t) {
        boolean success;
        if (this.passivator == null) {
            success = true;
            this.logger.trace("no passivator configured");
        } else {
            success = this.passivator.passivate(t);
            this.logger.trace("passivation for {} = {}", t, (Object)success);
        }
        return success;
    }

    public Validator<T> getValidator() {
        return this.validator;
    }

    public void setValidator(Validator<T> v) {
        this.logger.trace("setting validator: {}", v);
        this.validator = v;
    }

    public boolean validate(T t) {
        boolean success;
        if (this.validator == null) {
            success = true;
            this.logger.warn("validate called, but no validator configured");
        } else {
            success = this.validator.validate(t);
            this.logger.trace("validation for {} = {}", t, (Object)success);
        }
        return success;
    }

    public PruneStrategy getPruneStrategy() {
        return this.pruneStrategy;
    }

    public void setPruneStrategy(PruneStrategy ps) {
        this.logger.trace("setting pruneStrategy: {}", (Object)ps);
        this.pruneStrategy = ps;
    }
}

