/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.ldaptive.Connection;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.Response;
import org.ldaptive.pool.AbstractPool;
import org.ldaptive.pool.ActivationException;
import org.ldaptive.pool.ConnectionPool;
import org.ldaptive.pool.IdlePruneStrategy;
import org.ldaptive.pool.PoolException;
import org.ldaptive.pool.PooledConnectionProxy;
import org.ldaptive.pool.PooledConnectionStatistics;
import org.ldaptive.pool.Queue;
import org.ldaptive.pool.QueueType;
import org.ldaptive.pool.ValidationException;

public abstract class AbstractConnectionPool
extends AbstractPool<Connection>
implements ConnectionPool {
    protected final ReentrantLock poolLock = new ReentrantLock();
    protected final Condition poolNotEmpty = this.poolLock.newCondition();
    protected final ReentrantLock checkInLock = new ReentrantLock();
    protected final ReentrantLock checkOutLock = new ReentrantLock();
    protected Queue<PooledConnectionProxy> available;
    protected Queue<PooledConnectionProxy> active;
    private DefaultConnectionFactory connectionFactory;
    private boolean connectOnCreate = true;
    private QueueType queueType = QueueType.LIFO;
    private ScheduledExecutorService poolExecutor;
    private boolean initialized;

    public DefaultConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(DefaultConnectionFactory cf) {
        this.logger.trace("setting connectionFactory: {}", (Object)cf);
        this.connectionFactory = cf;
    }

    public boolean getConnectOnCreate() {
        return this.connectOnCreate;
    }

    public void setConnectOnCreate(boolean b) {
        this.logger.trace("setting connectOnCreate: {}", (Object)b);
        this.connectOnCreate = b;
    }

    public QueueType getQueueType() {
        return this.queueType;
    }

    public void setQueueType(QueueType type) {
        this.logger.trace("setting queueType: {}", (Object)type);
        this.queueType = type;
    }

    protected void isInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Pool has not been initialized");
        }
    }

    @Override
    public void initialize() {
        if (this.initialized) {
            throw new IllegalStateException("Pool has already been initialized");
        }
        this.logger.debug("beginning pool initialization");
        if ((this.getPoolConfig().isValidatePeriodically() || this.getPoolConfig().isValidateOnCheckIn() || this.getPoolConfig().isValidateOnCheckOut()) && this.getValidator() == null) {
            throw new IllegalStateException("Validation is enabled, but no validator has been configured");
        }
        this.getPoolConfig().makeImmutable();
        if (this.getPruneStrategy() == null) {
            this.setPruneStrategy(new IdlePruneStrategy());
            this.logger.debug("no prune strategy configured, using default prune strategy: {}", (Object)this.getPruneStrategy());
        }
        this.available = new Queue(this.queueType);
        this.active = new Queue(this.queueType);
        this.initializePool();
        this.logger.debug("initialized available queue: {}", this.available);
        this.poolExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            }
        });
        this.poolExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                AbstractConnectionPool.this.logger.debug("Begin prune task for {}", (Object)this);
                AbstractConnectionPool.this.prune();
                AbstractConnectionPool.this.logger.debug("End prune task for {}", (Object)this);
            }
        }, this.getPruneStrategy().getPrunePeriod(), this.getPruneStrategy().getPrunePeriod(), TimeUnit.SECONDS);
        this.logger.debug("prune pool task scheduled");
        this.poolExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                AbstractConnectionPool.this.logger.debug("Begin validate task for {}", (Object)this);
                AbstractConnectionPool.this.validate();
                AbstractConnectionPool.this.logger.debug("End validate task for {}", (Object)this);
            }
        }, this.getPoolConfig().getValidatePeriod(), this.getPoolConfig().getValidatePeriod(), TimeUnit.SECONDS);
        this.logger.debug("validate pool task scheduled");
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePool() {
        this.logger.debug("checking connection pool size >= {}", (Object)this.getPoolConfig().getMinPoolSize());
        this.poolLock.lock();
        try {
            for (int count = 0; this.available.size() < this.getPoolConfig().getMinPoolSize() && count < this.getPoolConfig().getMinPoolSize() * 2; ++count) {
                PooledConnectionProxy pc = this.createAvailableConnection();
                if (!this.getPoolConfig().isValidateOnCheckIn()) continue;
                if (this.validate(pc.getConnection())) {
                    this.logger.trace("connection passed initialize validation: {}", (Object)pc);
                    continue;
                }
                this.logger.warn("connection failed initialize validation: {}", (Object)pc);
                this.removeAvailableConnection(pc);
            }
            if (this.available.isEmpty() && this.getPoolConfig().getMinPoolSize() > 0) {
                throw new IllegalStateException("Could not initialize pool");
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.logger.debug("closing connection pool of size {}", (Object)(this.available.size() + this.active.size()));
        this.isInitialized();
        this.poolLock.lock();
        try {
            PooledConnectionProxy pc;
            while (!this.available.isEmpty()) {
                pc = this.available.remove();
                pc.getConnection().close();
                this.logger.trace("destroyed connection: {}", (Object)pc);
            }
            while (!this.active.isEmpty()) {
                pc = this.active.remove();
                pc.getConnection().close();
                this.logger.trace("destroyed connection: {}", (Object)pc);
            }
            this.logger.debug("pool closed");
        }
        finally {
            this.poolLock.unlock();
        }
        this.logger.debug("shutting down executor");
        this.poolExecutor.shutdown();
        this.logger.debug("executor shutdown");
        this.initialized = false;
    }

    @Override
    public abstract Connection getConnection() throws PoolException;

    public abstract void putConnection(Connection var1);

    protected PooledConnectionProxy createConnection() {
        Connection c = this.connectionFactory.getConnection();
        Response<Void> r = null;
        if (this.connectOnCreate) {
            try {
                r = c.open();
            }
            catch (LdapException e) {
                this.logger.error("unable to connect to the ldap", (Throwable)e);
                c = null;
            }
        }
        if (c != null) {
            return new DefaultPooledConnectionProxy(c, r);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PooledConnectionProxy createAvailableConnection() {
        PooledConnectionProxy pc = this.createConnection();
        if (pc != null) {
            this.poolLock.lock();
            try {
                this.available.add(pc);
                pc.getPooledConnectionStatistics().addAvailableStat();
                this.logger.trace("added available connection: {}", (Object)pc);
            }
            finally {
                this.poolLock.unlock();
            }
        } else {
            this.logger.warn("unable to create available connection");
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PooledConnectionProxy createActiveConnection() {
        PooledConnectionProxy pc = this.createConnection();
        if (pc != null) {
            this.poolLock.lock();
            try {
                this.active.add(pc);
                pc.getPooledConnectionStatistics().addActiveStat();
                this.logger.trace("added active connection: {}", (Object)pc);
            }
            finally {
                this.poolLock.unlock();
            }
        } else {
            this.logger.warn("unable to create active connection");
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAvailableConnection(PooledConnectionProxy pc) {
        boolean destroy = false;
        this.poolLock.lock();
        try {
            if (this.available.remove(pc)) {
                destroy = true;
            } else {
                this.logger.warn("attempt to remove unknown available connection: {}", (Object)pc);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        if (destroy) {
            pc.getConnection().close();
            this.logger.trace("destroyed connection: {}", (Object)pc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeActiveConnection(PooledConnectionProxy pc) {
        boolean destroy = false;
        this.poolLock.lock();
        try {
            if (this.active.remove(pc)) {
                destroy = true;
            } else {
                this.logger.warn("attempt to remove unknown active connection: {}", (Object)pc);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        if (destroy) {
            pc.getConnection().close();
            this.logger.trace("destroyed connection: {}", (Object)pc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAvailableAndActiveConnection(PooledConnectionProxy pc) {
        boolean destroy = false;
        this.poolLock.lock();
        try {
            if (this.available.remove(pc)) {
                destroy = true;
            } else {
                this.logger.debug("attempt to remove unknown available connection: {}", (Object)pc);
            }
            if (this.active.remove(pc)) {
                destroy = true;
            } else {
                this.logger.debug("attempt to remove unknown active connection: {}", (Object)pc);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        if (destroy) {
            pc.getConnection().close();
            this.logger.trace("destroyed connection: {}", (Object)pc);
        }
    }

    protected void activateAndValidateConnection(PooledConnectionProxy pc) throws PoolException {
        if (!this.activate(pc.getConnection())) {
            this.logger.warn("connection failed activation: {}", (Object)pc);
            this.removeAvailableAndActiveConnection(pc);
            throw new ActivationException("Activation of connection failed");
        }
        if (this.getPoolConfig().isValidateOnCheckOut() && !this.validate(pc.getConnection())) {
            this.logger.warn("connection failed check out validation: {}", (Object)pc);
            this.removeAvailableAndActiveConnection(pc);
            throw new ValidationException("Validation of connection failed");
        }
    }

    protected boolean validateAndPassivateConnection(PooledConnectionProxy pc) {
        if (!pc.getConnection().isOpen()) {
            this.logger.debug("connection not open: {}", (Object)pc);
            return false;
        }
        boolean valid = false;
        if (this.getPoolConfig().isValidateOnCheckIn()) {
            if (!this.validate(pc.getConnection())) {
                this.logger.warn("connection failed check in validation: {}", (Object)pc);
            } else {
                valid = true;
            }
        } else {
            valid = true;
        }
        if (valid && !this.passivate(pc.getConnection())) {
            valid = false;
            this.logger.warn("connection failed passivation: {}", (Object)pc);
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prune() {
        this.isInitialized();
        this.logger.trace("waiting for pool lock to prune {}", (Object)this.poolLock.getQueueLength());
        this.poolLock.lock();
        try {
            if (!this.available.isEmpty()) {
                int minPoolSize = this.getPoolConfig().getMinPoolSize();
                int currentPoolSize = this.active.size() + this.available.size();
                if (currentPoolSize > minPoolSize) {
                    this.logger.debug("pruning available pool of size {}", (Object)this.available.size());
                    int numConnToPrune = this.available.size();
                    Iterator<PooledConnectionProxy> connIter = this.available.iterator();
                    for (int i = 0; i < numConnToPrune && currentPoolSize > minPoolSize; ++i) {
                        PooledConnectionProxy pc = connIter.next();
                        if (!this.getPruneStrategy().prune(pc)) continue;
                        connIter.remove();
                        pc.getConnection().close();
                        this.logger.trace("destroyed connection: {}", (Object)pc);
                        --currentPoolSize;
                    }
                    if (numConnToPrune == this.available.size()) {
                        this.logger.debug("prune strategy did not remove any connections");
                    } else {
                        this.logger.debug("available pool size pruned to {}", (Object)this.available.size());
                    }
                } else {
                    this.logger.debug("pool size is at the minimum, no connections pruned");
                }
            } else {
                this.logger.debug("no connections currently available, no connections pruned");
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        this.isInitialized();
        this.poolLock.lock();
        try {
            if (!this.available.isEmpty()) {
                if (this.getPoolConfig().isValidatePeriodically()) {
                    this.logger.debug("validate available pool of size {}", (Object)this.available.size());
                    ArrayList<PooledConnectionProxy> remove = new ArrayList<PooledConnectionProxy>();
                    for (PooledConnectionProxy pc : this.available) {
                        this.logger.trace("validating {}", (Object)pc);
                        if (this.validate(pc.getConnection())) {
                            this.logger.trace("connection passed validation: {}", (Object)pc);
                            continue;
                        }
                        this.logger.warn("connection failed validation: {}", (Object)pc);
                        remove.add(pc);
                    }
                    for (PooledConnectionProxy pc : remove) {
                        this.logger.trace("removing {} from the pool", (Object)pc);
                        this.available.remove(pc);
                        pc.getConnection().close();
                        this.logger.trace("destroyed connection: {}", (Object)pc);
                    }
                }
                this.initializePool();
                this.logger.debug("pool size after validation is {}", (Object)this.available.size());
            } else {
                this.logger.debug("all connections currently active, no validation pruned");
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    @Override
    public int availableCount() {
        return this.available.size();
    }

    @Override
    public int activeCount() {
        return this.active.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PooledConnectionStatistics> getPooledConnectionStatistics() {
        this.isInitialized();
        Set<PooledConnectionStatistics> stats = Collections.unmodifiableSet(new HashSet());
        this.poolLock.lock();
        try {
            for (PooledConnectionProxy cp : this.available) {
                stats.add(cp.getPooledConnectionStatistics());
            }
            for (PooledConnectionProxy cp : this.active) {
                stats.add(cp.getPooledConnectionStatistics());
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return stats;
    }

    protected Connection createConnectionProxy(PooledConnectionProxy pc) {
        return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)pc);
    }

    protected PooledConnectionProxy retrieveConnectionProxy(Connection proxy) {
        return (PooledConnectionProxy)Proxy.getInvocationHandler(proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        return String.format("[%s@%d::poolConfig=%s, activator=%s, passivator=%s, validator=%s pruneStrategy=%s, connectOnCreate=%s, connectionFactory=%s, availableCount=%s, activeCount=%s]", this.getClass().getName(), this.hashCode(), this.getPoolConfig(), this.getActivator(), this.getPassivator(), this.getValidator(), this.getPruneStrategy(), this.connectOnCreate, this.connectionFactory, this.availableCount(), this.activeCount());
    }

    protected class DefaultPooledConnectionProxy
    implements PooledConnectionProxy {
        private static final int HASH_CODE_SEED = 503;
        private final Connection conn;
        private Response<Void> openResponse;
        private final long createdTime = System.currentTimeMillis();
        private final PooledConnectionStatistics statistics = new PooledConnectionStatistics(AbstractConnectionPool.this.getPruneStrategy().getStatisticsSize());

        public DefaultPooledConnectionProxy(Connection c, Response<Void> r) {
            this.conn = c;
            this.openResponse = r;
        }

        @Override
        public ConnectionPool getConnectionPool() {
            return AbstractConnectionPool.this;
        }

        @Override
        public Connection getConnection() {
            return this.conn;
        }

        @Override
        public long getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public PooledConnectionStatistics getPooledConnectionStatistics() {
            return this.statistics;
        }

        public boolean equals(Object o) {
            return LdapUtils.areEqual(this, o);
        }

        public int hashCode() {
            return LdapUtils.computeHashCode(503, this.conn);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Response<Void> retValue = null;
            if ("open".equals(method.getName())) {
                if (!this.conn.isOpen()) {
                    try {
                        this.openResponse = (Response)method.invoke((Object)this.conn, args);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                }
                retValue = this.openResponse;
            } else if ("reopen".equals(method.getName())) {
                try {
                    this.openResponse = (Response)method.invoke((Object)this.conn, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
                retValue = this.openResponse;
            } else if ("close".equals(method.getName())) {
                AbstractConnectionPool.this.putConnection((Connection)proxy);
            } else {
                try {
                    retValue = method.invoke((Object)this.conn, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            return retValue;
        }
    }
}

