/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.jaas;

import com.sun.security.auth.callback.TextCallbackHandler;
import java.security.Principal;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ldaptive.LdapException;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchRequest;
import org.ldaptive.jaas.AbstractLoginModule;
import org.ldaptive.jaas.LdapDnPrincipal;
import org.ldaptive.jaas.LdapPrincipal;
import org.ldaptive.jaas.LdapRole;
import org.ldaptive.jaas.PropertiesRoleResolverFactory;
import org.ldaptive.jaas.RoleResolver;
import org.ldaptive.jaas.RoleResolverFactory;

public class LdapRoleAuthorizationModule
extends AbstractLoginModule {
    private String roleFilter;
    private String[] roleAttribute = new String[0];
    private boolean noResultsIsError;
    private RoleResolverFactory roleResolverFactory;
    private RoleResolver roleResolver;
    private SearchRequest searchRequest;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        for (String key : options.keySet()) {
            String value = (String)options.get(key);
            if ("roleFilter".equalsIgnoreCase(key)) {
                this.roleFilter = value;
                continue;
            }
            if ("roleAttribute".equalsIgnoreCase(key)) {
                if ("*".equals(value)) {
                    this.roleAttribute = null;
                    continue;
                }
                this.roleAttribute = value.split(",");
                continue;
            }
            if ("noResultsIsError".equalsIgnoreCase(key)) {
                this.noResultsIsError = Boolean.valueOf(value);
                continue;
            }
            if (!"roleResolverFactory".equalsIgnoreCase(key)) continue;
            try {
                this.roleResolverFactory = (RoleResolverFactory)Class.forName(value).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (this.roleResolverFactory == null) {
            this.roleResolverFactory = new PropertiesRoleResolverFactory();
        }
        this.logger.trace("roleResolverFactory = {}, roleFilter = {}, roleAttribute = {}, noResultsIsError = {}", new Object[]{this.roleResolverFactory, this.roleFilter, Arrays.toString(this.roleAttribute), this.noResultsIsError});
        this.roleResolver = this.roleResolverFactory.createRoleResolver(options);
        this.logger.debug("Retrieved role resolver from factory: {}", (Object)this.roleResolver);
        this.searchRequest = this.roleResolverFactory.createSearchRequest(options);
        this.searchRequest.setReturnAttributes(this.roleAttribute);
        this.logger.debug("Retrieved search request from factory: {}", (Object)this.searchRequest);
    }

    @Override
    public boolean login() throws LoginException {
        try {
            String loginDn;
            String loginName;
            NameCallback nameCb = new NameCallback("Enter user: ");
            PasswordCallback passCb = new PasswordCallback("Enter user password: ", false);
            this.getCredentials(nameCb, passCb, false);
            if (nameCb.getName() == null && this.tryFirstPass) {
                this.getCredentials(nameCb, passCb, true);
            }
            if ((loginName = nameCb.getName()) != null && this.setLdapPrincipal) {
                this.principals.add(new LdapPrincipal(loginName, null));
                this.loginSuccess = true;
            }
            if ((loginDn = (String)this.sharedState.get("org.ldaptive.jaas.login.entryDn")) != null && this.setLdapDnPrincipal) {
                this.principals.add(new LdapDnPrincipal(loginDn, null));
                this.loginSuccess = true;
            }
            SearchFilter filter = new SearchFilter(this.roleFilter);
            filter.setParameter("dn", (Object)loginDn);
            filter.setParameter("user", (Object)loginName);
            this.searchRequest.setSearchFilter(filter);
            Set<LdapRole> lr = this.roleResolver.search(this.searchRequest);
            if (lr.isEmpty() && this.noResultsIsError) {
                this.loginSuccess = false;
                throw new LoginException("Could not find roles using " + this.roleFilter);
            }
            this.roles.addAll(lr);
            if (this.defaultRole != null && !this.defaultRole.isEmpty()) {
                this.roles.addAll(this.defaultRole);
            }
            if (!this.roles.isEmpty()) {
                this.loginSuccess = true;
            }
            this.storeCredentials(nameCb, passCb, null);
        }
        catch (LdapException e) {
            this.logger.debug("Error occured attempting role lookup", (Throwable)e);
            this.loginSuccess = false;
            throw new LoginException(e.getMessage());
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        String name = "ldaptive-role";
        if (args.length > 0) {
            name = args[0];
        }
        LoginContext lc = new LoginContext(name, new TextCallbackHandler());
        lc.login();
        Set<Principal> principals = lc.getSubject().getPrincipals();
        System.out.println("Subject Principal(s): ");
        for (Principal p : principals) {
            System.out.println("  " + p.getName());
        }
        lc.logout();
    }
}

