/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.jaas;

import com.sun.security.auth.callback.TextCallbackHandler;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ldaptive.LdapException;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.jaas.AbstractLoginModule;
import org.ldaptive.jaas.AuthenticatorFactory;
import org.ldaptive.jaas.LdapDnPrincipal;
import org.ldaptive.jaas.LdapPrincipal;
import org.ldaptive.jaas.PropertiesAuthenticatorFactory;

public class LdapDnAuthorizationModule
extends AbstractLoginModule {
    private boolean noResultsIsError;
    private AuthenticatorFactory authenticatorFactory;
    private Authenticator auth;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        for (String key : options.keySet()) {
            String value = (String)options.get(key);
            if ("noResultsIsError".equalsIgnoreCase(key)) {
                this.noResultsIsError = Boolean.valueOf(value);
                continue;
            }
            if (!"authenticatorFactory".equalsIgnoreCase(key)) continue;
            try {
                this.authenticatorFactory = (AuthenticatorFactory)Class.forName(value).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (this.authenticatorFactory == null) {
            this.authenticatorFactory = new PropertiesAuthenticatorFactory();
        }
        this.logger.trace("authenticatorFactory = {}, noResultsIsError = {}", (Object)this.authenticatorFactory, (Object)this.noResultsIsError);
        this.auth = this.authenticatorFactory.createAuthenticator(options);
        this.logger.debug("Retrieved authenticator from factory: {}", (Object)this.auth);
    }

    @Override
    public boolean login() throws LoginException {
        try {
            String loginDn;
            String loginName;
            NameCallback nameCb = new NameCallback("Enter user: ");
            PasswordCallback passCb = new PasswordCallback("Enter user password: ", false);
            this.getCredentials(nameCb, passCb, false);
            if (nameCb.getName() == null && this.tryFirstPass) {
                this.getCredentials(nameCb, passCb, true);
            }
            if ((loginName = nameCb.getName()) != null && this.setLdapPrincipal) {
                this.principals.add(new LdapPrincipal(loginName, null));
                this.loginSuccess = true;
            }
            if ((loginDn = this.auth.resolveDn(nameCb.getName())) == null && this.noResultsIsError) {
                this.loginSuccess = false;
                throw new LoginException("Could not find DN for " + nameCb.getName());
            }
            if (loginDn != null && this.setLdapDnPrincipal) {
                this.principals.add(new LdapDnPrincipal(loginDn, null));
                this.loginSuccess = true;
            }
            if (this.defaultRole != null && !this.defaultRole.isEmpty()) {
                this.roles.addAll(this.defaultRole);
                this.loginSuccess = true;
            }
            this.storeCredentials(nameCb, passCb, loginDn);
        }
        catch (LdapException e) {
            this.logger.debug("Error occured attempting DN lookup", (Throwable)e);
            this.loginSuccess = false;
            throw new LoginException(e != null ? e.getMessage() : "DN resolution error");
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        String name = "ldaptive-dn";
        if (args.length > 0) {
            name = args[0];
        }
        LoginContext lc = new LoginContext(name, new TextCallbackHandler());
        lc.login();
        Set<Principal> principals = lc.getSubject().getPrincipals();
        System.out.println("Subject Principal(s): ");
        for (Principal p : principals) {
            System.out.println("  " + p.getName());
        }
        lc.logout();
    }
}

