/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.io;

import java.io.IOException;
import java.io.Writer;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchResult;
import org.ldaptive.io.LdapResultWriter;

public class LdifWriter
implements LdapResultWriter {
    private static final int NUL_CHAR = 0;
    private static final int LF_CHAR = 10;
    private static final int CR_CHAR = 13;
    private static final int SP_CHAR = 32;
    private static final int COLON_CHAR = 58;
    private static final int LA_CHAR = 60;
    private static final int MAX_ASCII_CHAR = 127;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Writer ldifWriter;

    public LdifWriter(Writer writer) {
        this.ldifWriter = writer;
    }

    @Override
    public void write(SearchResult result) throws IOException {
        this.ldifWriter.write(this.createLdif(result));
        this.ldifWriter.flush();
    }

    protected String createLdif(SearchResult result) {
        StringBuilder ldif = new StringBuilder();
        if (result != null) {
            for (LdapEntry le : result.getEntries()) {
                ldif.append(this.createLdifEntry(le));
            }
        }
        return ldif.toString();
    }

    protected String createLdifEntry(LdapEntry entry) {
        if (entry == null) {
            return "";
        }
        StringBuilder entryLdif = new StringBuilder();
        String dn = entry.getDn();
        if (dn != null) {
            if (this.encodeData(dn)) {
                String encodedDn = LdapUtils.base64Encode(dn);
                if (encodedDn != null) {
                    entryLdif.append("dn:: ").append(dn).append(LINE_SEPARATOR);
                }
            } else {
                entryLdif.append("dn: ").append(dn).append(LINE_SEPARATOR);
            }
        }
        for (LdapAttribute attr : entry.getAttributes()) {
            String attrName = attr.getName();
            for (String attrValue : attr.getStringValues()) {
                if (attr.isBinary()) {
                    entryLdif.append(attrName).append(":: ").append(attrValue).append(LINE_SEPARATOR);
                    continue;
                }
                if (this.encodeData(attrValue)) {
                    entryLdif.append(attrName).append(":: ").append(LdapUtils.base64Encode(attrValue)).append(LINE_SEPARATOR);
                    continue;
                }
                entryLdif.append(attrName).append(": ").append(attrValue).append(LINE_SEPARATOR);
            }
        }
        if (entryLdif.length() > 0) {
            entryLdif.append(LINE_SEPARATOR);
        }
        return entryLdif.toString();
    }

    private boolean encodeData(String data) {
        boolean encode = false;
        char[] dataCharArray = data.toCharArray();
        for (int i = 0; i < dataCharArray.length; ++i) {
            char charInt = dataCharArray[i];
            if (charInt == '\u0000') {
                encode = true;
                continue;
            }
            if (charInt == '\n') {
                encode = true;
                continue;
            }
            if (charInt == '\r') {
                encode = true;
                continue;
            }
            if (charInt == ' ' && (i == 0 || i == dataCharArray.length - 1)) {
                encode = true;
                continue;
            }
            if (charInt == ':' && i == 0) {
                encode = true;
                continue;
            }
            if (charInt == '<' && i == 0) {
                encode = true;
                continue;
            }
            if (charInt <= '\u007f') continue;
            encode = true;
        }
        return encode;
    }
}

