/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.io;

import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchResult;
import org.ldaptive.SortBehavior;
import org.ldaptive.io.LdapResultReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Dsmlv1Reader
implements LdapResultReader {
    private static final DocumentBuilderFactory DOC_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private final Reader dsmlReader;
    private final SortBehavior sortBehavior;

    public Dsmlv1Reader(Reader reader) {
        this(reader, SortBehavior.getDefaultSortBehavior());
    }

    public Dsmlv1Reader(Reader reader, SortBehavior sb) {
        this.dsmlReader = reader;
        if (sb == null) {
            throw new IllegalArgumentException("Sort behavior cannot be null");
        }
        this.sortBehavior = sb;
    }

    @Override
    public SearchResult read() throws IOException {
        try {
            DocumentBuilder db = DOC_BUILDER_FACTORY.newDocumentBuilder();
            Document dsml = db.parse(new InputSource(this.dsmlReader));
            return this.createLdapResult(dsml);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    protected SearchResult createLdapResult(Document doc) {
        SearchResult result = new SearchResult(this.sortBehavior);
        if (doc != null && doc.hasChildNodes()) {
            NodeList nodes = doc.getElementsByTagName("dsml:entry");
            for (int i = 0; i < nodes.getLength(); ++i) {
                LdapEntry le = this.createLdapEntry((Element)nodes.item(i));
                result.addEntry(le);
            }
        }
        return result;
    }

    protected LdapEntry createLdapEntry(Element entryElement) {
        LdapEntry ldapEntry = new LdapEntry(this.sortBehavior);
        ldapEntry.setDn("");
        if (entryElement != null) {
            String name = entryElement.getAttribute("dn");
            if (name != null) {
                ldapEntry.setDn(name);
            }
            if (entryElement.hasChildNodes()) {
                Element ocElement;
                NodeList ocNodes = entryElement.getElementsByTagName("dsml:objectclass");
                if (ocNodes.getLength() > 0 && (ocElement = (Element)ocNodes.item(0)) != null && ocElement.hasChildNodes()) {
                    LdapAttribute ldapAttribute = this.createLdapAttribute("objectClass", ocElement.getElementsByTagName("dsml:oc-value"));
                    ldapEntry.addAttribute(ldapAttribute);
                }
                NodeList attrNodes = entryElement.getElementsByTagName("dsml:attr");
                for (int i = 0; i < attrNodes.getLength(); ++i) {
                    String attrName;
                    Element attrElement = (Element)attrNodes.item(i);
                    String string = attrName = attrElement.hasAttribute("name") ? attrElement.getAttribute("name") : null;
                    if (attrName == null || !attrElement.hasChildNodes()) continue;
                    LdapAttribute ldapAttribute = this.createLdapAttribute(attrName, attrElement.getElementsByTagName("dsml:value"));
                    ldapEntry.addAttribute(ldapAttribute);
                }
            }
        }
        return ldapEntry;
    }

    protected LdapAttribute createLdapAttribute(String name, NodeList nodes) {
        boolean isBase64 = false;
        HashSet<Object> values = new HashSet<Object>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element valueElement = (Element)nodes.item(i);
            if (valueElement == null) continue;
            if (valueElement.hasAttribute("encoding") && "base64".equals(valueElement.getAttribute("encoding"))) {
                isBase64 = true;
            }
            values.add(this.getAttrValue(valueElement, isBase64));
        }
        return LdapAttribute.createLdapAttribute(this.sortBehavior, name, values);
    }

    protected Object getAttrValue(Element valueElement, boolean base64) {
        String value = valueElement.getChildNodes().item(0).getNodeValue();
        if (base64) {
            return LdapUtils.base64Decode(value);
        }
        return value;
    }

    static {
        DOC_BUILDER_FACTORY.setNamespaceAware(true);
    }
}

