/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.handler;

import org.ldaptive.Connection;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchRequest;
import org.ldaptive.handler.AbstractSearchEntryHandler;

public class DnAttributeEntryHandler
extends AbstractSearchEntryHandler {
    private static final int HASH_CODE_SEED = 823;
    private String dnAttributeName = "entryDN";
    private boolean addIfExists;

    public String getDnAttributeName() {
        return this.dnAttributeName;
    }

    public void setDnAttributeName(String name) {
        this.dnAttributeName = name;
    }

    public boolean isAddIfExists() {
        return this.addIfExists;
    }

    public void setAddIfExists(boolean b) {
        this.addIfExists = b;
    }

    @Override
    protected void processAttributes(Connection conn, SearchRequest request, SearchEntry entry) throws LdapException {
        if (entry.getAttribute(this.dnAttributeName) == null) {
            entry.addAttribute(new LdapAttribute(this.dnAttributeName, entry.getDn()));
        } else if (this.addIfExists) {
            entry.getAttribute(this.dnAttributeName).addStringValue(entry.getDn());
        }
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(823, this.addIfExists, this.dnAttributeName);
    }
}

