/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control;

import org.ldaptive.control.AbstractControl;
import org.ldaptive.control.PagedResultsControl;
import org.ldaptive.control.PasswordPolicyControl;
import org.ldaptive.control.ResponseControl;
import org.ldaptive.control.SortResponseControl;
import org.ldaptive.control.SyncDoneControl;
import org.ldaptive.control.SyncStateControl;
import org.ldaptive.control.VirtualListViewResponseControl;

public final class ControlFactory {
    private ControlFactory() {
    }

    public static ResponseControl createResponseControl(String oid, boolean critical, byte[] encoded) {
        AbstractControl ctl;
        if ("1.2.840.113556.1.4.474".equals(oid)) {
            ctl = new SortResponseControl(critical);
            ctl.decode(encoded);
        } else if ("1.2.840.113556.1.4.319".equals(oid)) {
            ctl = new PagedResultsControl(critical);
            ctl.decode(encoded);
        } else if ("2.16.840.1.113730.3.4.10".equals(oid)) {
            ctl = new VirtualListViewResponseControl(critical);
            ctl.decode(encoded);
        } else if ("1.3.6.1.4.1.42.2.27.8.5.1".equals(oid)) {
            ctl = new PasswordPolicyControl(critical);
            ctl.decode(encoded);
        } else if ("1.3.6.1.4.1.4203.1.9.1.2".equals(oid)) {
            ctl = new SyncStateControl(critical);
            ctl.decode(encoded);
        } else if ("1.3.6.1.4.1.4203.1.9.1.3".equals(oid)) {
            ctl = new SyncDoneControl(critical);
            ctl.decode(encoded);
        } else {
            throw new IllegalArgumentException("Unknown OID: " + oid);
        }
        return ctl;
    }
}

