/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.ldaptive.LdapException;
import org.ldaptive.Operation;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.concurrent.OperationWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperationWorker<Q extends Request, S>
implements OperationWorker<Q, S> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Operation<Q, S> operation;
    private final ExecutorService service;

    public AbstractOperationWorker(Operation<Q, S> op) {
        this(op, Executors.newCachedThreadPool());
    }

    public AbstractOperationWorker(Operation<Q, S> op, ExecutorService es) {
        this.operation = op;
        this.service = es;
    }

    @Override
    public Future<Response<S>> execute(Q request) {
        return this.service.submit(AbstractOperationWorker.createCallable(this.operation, request));
    }

    @Override
    public Collection<Future<Response<S>>> execute(Q ... requests) {
        ArrayList<Future<Response<S>>> results = new ArrayList<Future<Response<S>>>(requests.length);
        for (Q request : requests) {
            results.add(this.service.submit(AbstractOperationWorker.createCallable(this.operation, request)));
        }
        return results;
    }

    @Override
    public Collection<Response<S>> executeToCompletion(Q ... requests) {
        ExecutorCompletionService<Response<S>> cs = new ExecutorCompletionService<Response<S>>(this.service);
        ArrayList<Response<S>> results = new ArrayList<Response<S>>(requests.length);
        for (Q request : requests) {
            cs.submit(AbstractOperationWorker.createCallable(this.operation, request));
        }
        for (Q request : requests) {
            try {
                results.add((Response<S>)cs.take().get());
            }
            catch (ExecutionException e) {
                this.logger.debug("ExecutionException thrown, ignoring", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.logger.warn("InterruptedException thrown, ignoring", (Throwable)e);
            }
        }
        return results;
    }

    public static <Q extends Request, S> Callable<Response<S>> createCallable(final Operation<Q, S> operation, final Q request) {
        return new Callable<Response<S>>(){

            @Override
            public Response<S> call() throws LdapException {
                return operation.execute(request);
            }
        };
    }

    public void shutdown() {
        this.service.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }
}

