/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Arrays;
import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchResult;
import org.ldaptive.auth.AbstractSearchEntryResolver;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.pool.PooledConnectionFactory;
import org.ldaptive.pool.PooledConnectionFactoryManager;

public class PooledSearchEntryResolver
extends AbstractSearchEntryResolver
implements PooledConnectionFactoryManager {
    private PooledConnectionFactory factory;

    public PooledSearchEntryResolver() {
    }

    public PooledSearchEntryResolver(PooledConnectionFactory cf) {
        this.setConnectionFactory(cf);
    }

    public PooledSearchEntryResolver(PooledConnectionFactory cf, String ... attrs) {
        this.setConnectionFactory(cf);
        this.setReturnAttributes(attrs);
    }

    @Override
    public PooledConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    @Override
    public void setConnectionFactory(PooledConnectionFactory cf) {
        this.factory = cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SearchResult performLdapSearch(Connection conn, AuthenticationCriteria ac) throws LdapException {
        Connection pooledConn = null;
        try {
            pooledConn = this.factory.getConnection();
            SearchOperation search = new SearchOperation(pooledConn);
            SearchResult searchResult = (SearchResult)search.execute(this.createSearchRequest(ac, this.getReturnAttributes())).getResult();
            return searchResult;
        }
        finally {
            if (pooledConn != null) {
                pooledConn.close();
            }
        }
    }

    public String toString() {
        return String.format("[%s@%d::factory=%s, returnAttributes=%s]", this.getClass().getName(), this.hashCode(), this.factory, Arrays.toString(this.getReturnAttributes()));
    }
}

