/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Arrays;
import org.ldaptive.LdapException;
import org.ldaptive.auth.DnResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatDnResolver
implements DnResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String formatString;
    private Object[] formatArgs;

    public FormatDnResolver() {
    }

    public FormatDnResolver(String format) {
        this.setFormat(format);
    }

    public FormatDnResolver(String format, Object[] args) {
        this.setFormat(format);
        this.setFormatArgs(args);
    }

    public String getFormat() {
        return this.formatString;
    }

    public void setFormat(String format) {
        this.formatString = format;
    }

    public Object[] getFormatArgs() {
        return this.formatArgs;
    }

    public void setFormatArgs(Object[] args) {
        this.formatArgs = args;
    }

    @Override
    public String resolve(String user) throws LdapException {
        String dn = null;
        if (user != null && !"".equals(user)) {
            this.logger.debug("Formatting DN with {}", (Object)this.formatString);
            if (this.formatArgs != null && this.formatArgs.length > 0) {
                Object[] args = new Object[this.formatArgs.length + 1];
                args[0] = user;
                System.arraycopy(this.formatArgs, 0, args, 1, this.formatArgs.length);
                dn = String.format(this.formatString, args);
            } else {
                dn = String.format(this.formatString, user);
            }
        } else {
            this.logger.debug("User input was empty or null");
        }
        return dn;
    }

    public String toString() {
        return String.format("[%s@%d::formatString=%s, formatArgs=%s]", this.getClass().getName(), this.hashCode(), this.formatString, Arrays.toString(this.formatArgs));
    }
}

