/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Calendar;
import javax.security.auth.login.LoginException;

public class AccountState {
    private final Warning[] accountWarnings;
    private final Error[] accountErrors;

    public AccountState(Warning ... warnings) {
        this.accountWarnings = warnings;
        this.accountErrors = null;
    }

    public AccountState(Error ... errors) {
        this.accountWarnings = null;
        this.accountErrors = errors;
    }

    public Warning[] getWarnings() {
        return this.accountWarnings;
    }

    public Warning getWarning() {
        return this.accountWarnings != null && this.accountWarnings.length > 0 ? this.accountWarnings[0] : null;
    }

    public Error[] getErrors() {
        return this.accountErrors;
    }

    public Error getError() {
        return this.accountErrors != null && this.accountErrors.length > 0 ? this.accountErrors[0] : null;
    }

    public static class DefaultWarning
    implements Warning {
        private final Calendar expiration;
        private final int loginsRemaining;

        public DefaultWarning(Calendar exp, int remaining) {
            this.expiration = exp;
            this.loginsRemaining = remaining;
        }

        @Override
        public Calendar getExpiration() {
            return this.expiration;
        }

        @Override
        public int getLoginsRemaining() {
            return this.loginsRemaining;
        }
    }

    public static interface Warning {
        public Calendar getExpiration();

        public int getLoginsRemaining();
    }

    public static interface Error {
        public int getCode();

        public String getMessage();

        public void throwSecurityException() throws LoginException;
    }
}

