/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Arrays;
import org.ldaptive.Connection;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.auth.EntryResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchEntryResolver
implements EntryResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String[] retAttrs;

    public String[] getReturnAttributes() {
        return this.retAttrs;
    }

    public void setReturnAttributes(String ... attrs) {
        this.retAttrs = attrs;
    }

    protected abstract SearchResult performLdapSearch(Connection var1, AuthenticationCriteria var2) throws LdapException;

    protected SearchRequest createSearchRequest(AuthenticationCriteria ac, String[] returnAttributes) {
        return SearchRequest.newObjectScopeSearchRequest(ac.getDn(), returnAttributes);
    }

    @Override
    public LdapEntry resolve(Connection conn, AuthenticationCriteria ac) throws LdapException {
        this.logger.debug("resolve criteria={} with attributes={}", (Object)ac, (Object)(this.retAttrs == null ? "<all attributes>" : Arrays.toString(this.retAttrs)));
        SearchResult result = this.performLdapSearch(conn, ac);
        this.logger.debug("resolved result={} for criteria={} with attributes={}", new Object[]{result, ac, this.retAttrs == null ? "<all attributes>" : Arrays.toString(this.retAttrs)});
        return this.resolveEntry(result);
    }

    protected LdapEntry resolveEntry(SearchResult result) {
        return result.getEntry();
    }
}

