/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.ldaptive.CompareOperation;
import org.ldaptive.CompareRequest;
import org.ldaptive.Connection;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.Response;
import org.ldaptive.auth.AbstractAuthenticationHandler;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.auth.AuthenticationHandlerResponse;

public abstract class AbstractCompareAuthenticationHandler
extends AbstractAuthenticationHandler {
    protected static final String DEFAULT_SCHEME = "SHA";
    private String passwordScheme = "SHA";

    public String getPasswordScheme() {
        return this.passwordScheme;
    }

    public void setPasswordScheme(String s) {
        this.passwordScheme = s;
    }

    @Override
    protected AuthenticationHandlerResponse authenticateInternal(Connection c, AuthenticationCriteria criteria) throws LdapException {
        byte[] hash;
        try {
            MessageDigest md = MessageDigest.getInstance(this.passwordScheme);
            md.update(criteria.getCredential().getBytes());
            hash = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new LdapException(e);
        }
        LdapAttribute la = new LdapAttribute("userPassword", new byte[][]{String.format("{%s}%s", this.passwordScheme, LdapUtils.base64Encode(hash)).getBytes()});
        CompareOperation compare = new CompareOperation(c);
        CompareRequest request = new CompareRequest(criteria.getDn(), la);
        request.setControls(this.getAuthenticationControls());
        Response compareResponse = compare.execute(request);
        return new AuthenticationHandlerResponse((Boolean)compareResponse.getResult(), compareResponse.getResultCode(), c, compareResponse.getMessage(), compareResponse.getControls(), compareResponse.getMessageId());
    }

    @Override
    protected abstract Connection getConnection() throws LdapException;
}

