/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.regex.Pattern;
import org.ldaptive.io.Base64;
import org.ldaptive.io.Hex;

public final class LdapUtils {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final int READ_BUFFER_SIZE = 128;
    private static final int HASH_CODE_PRIME = 113;
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String FILE_PREFIX = "file:";

    private LdapUtils() {
    }

    public static String base64Encode(byte[] value) {
        return value != null ? new String(Base64.encodeToByte(value, false), UTF8_CHARSET) : null;
    }

    public static String base64Encode(String value) {
        return value != null ? LdapUtils.base64Encode(value.getBytes(UTF8_CHARSET)) : null;
    }

    public static String utf8Encode(byte[] value) {
        return value != null ? new String(value, UTF8_CHARSET) : null;
    }

    public static byte[] utf8Encode(String value) {
        return value != null ? value.getBytes(UTF8_CHARSET) : null;
    }

    public static char[] hexEncode(byte[] value) {
        return value != null ? Hex.encode(value) : null;
    }

    public static byte[] base64Decode(String value) {
        return value != null ? Base64.decode(value.getBytes()) : null;
    }

    public static byte[] hexDecode(char[] value) {
        return value != null ? Hex.decode(value) : null;
    }

    public static byte[] readURL(URL url) throws IOException {
        return LdapUtils.readInputStream(url.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            int length;
            byte[] buffer = new byte[128];
            while ((length = is.read(buffer)) != -1) {
                data.write(buffer, 0, length);
            }
        }
        finally {
            is.close();
            data.close();
        }
        return data.toByteArray();
    }

    public static <T> T[] concatArrays(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            if (array == null) continue;
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            if (array == null) continue;
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static boolean areEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o2 != null && (o1 == o2 || o1.getClass() == o2.getClass() && o1.hashCode() == o2.hashCode());
    }

    public static int computeHashCode(int seed, Object ... objects) {
        if (objects == null || objects.length == 0) {
            return seed * 113;
        }
        int hc = seed;
        for (Object object : objects) {
            hc = 113 * hc;
            if (object == null) continue;
            if (object instanceof List || object instanceof Queue) {
                int index = 1;
                for (Object o : (Collection)object) {
                    hc += LdapUtils.computeHashCode(o) * index++;
                }
                continue;
            }
            if (object instanceof Collection) {
                for (Object o : (Collection)object) {
                    hc += LdapUtils.computeHashCode(o);
                }
                continue;
            }
            hc += LdapUtils.computeHashCode(object);
        }
        return hc;
    }

    private static int computeHashCode(Object object) {
        int hc = 0;
        hc = object instanceof byte[] ? (hc += Arrays.hashCode((byte[])object)) : (object instanceof Object[] ? (hc += Arrays.hashCode((Object[])object)) : (hc += object.hashCode()));
        return hc;
    }

    public static boolean isIPAddress(String s) {
        return s != null && (IPV4_PATTERN.matcher(s).matches() || IPV6_STD_PATTERN.matcher(s).matches() || IPV6_HEX_COMPRESSED_PATTERN.matcher(s).matches());
    }

    public static InputStream getResource(String path) throws IOException {
        InputStream is;
        if (path.startsWith(CLASSPATH_PREFIX)) {
            is = LdapUtils.class.getResourceAsStream(path.substring(CLASSPATH_PREFIX.length()));
        } else if (path.startsWith(FILE_PREFIX)) {
            is = new FileInputStream(new File(path.substring(FILE_PREFIX.length())));
        } else {
            throw new IllegalArgumentException("path must start with either classpath: or file:");
        }
        return is;
    }
}

