/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.Arrays;
import org.ldaptive.ResponseMessage;
import org.ldaptive.ResultCode;
import org.ldaptive.control.ResponseControl;

public class LdapException
extends Exception
implements ResponseMessage {
    private static final long serialVersionUID = -1283840230801970620L;
    private final ResultCode resultCode;
    private final String matchedDn;
    private final ResponseControl[] responseControls;
    private final String[] referralURLs;
    private final int messageId;

    public LdapException(String msg) {
        super(msg);
        this.resultCode = null;
        this.matchedDn = null;
        this.responseControls = null;
        this.referralURLs = null;
        this.messageId = -1;
    }

    public LdapException(String msg, ResultCode code) {
        super(msg);
        this.resultCode = code;
        this.matchedDn = null;
        this.responseControls = null;
        this.referralURLs = null;
        this.messageId = -1;
    }

    public LdapException(String msg, ResultCode code, String dn) {
        super(msg);
        this.resultCode = code;
        this.matchedDn = dn;
        this.responseControls = null;
        this.referralURLs = null;
        this.messageId = -1;
    }

    public LdapException(String msg, ResultCode code, String dn, ResponseControl[] c) {
        super(msg);
        this.resultCode = code;
        this.matchedDn = dn;
        this.responseControls = c;
        this.referralURLs = null;
        this.messageId = -1;
    }

    public LdapException(String msg, ResultCode code, String dn, ResponseControl[] c, String[] urls) {
        super(msg);
        this.resultCode = code;
        this.matchedDn = dn;
        this.responseControls = c;
        this.referralURLs = urls;
        this.messageId = -1;
    }

    public LdapException(String msg, ResultCode code, String dn, ResponseControl[] c, String[] urls, int id) {
        super(msg);
        this.resultCode = code;
        this.matchedDn = dn;
        this.responseControls = c;
        this.referralURLs = urls;
        this.messageId = id;
    }

    public LdapException(Exception e) {
        super(e);
        this.resultCode = null;
        this.matchedDn = null;
        this.responseControls = null;
        this.referralURLs = null;
        this.messageId = -1;
    }

    public LdapException(Exception e, ResultCode code) {
        super(e);
        this.resultCode = code;
        this.matchedDn = null;
        this.responseControls = null;
        this.referralURLs = null;
        this.messageId = -1;
    }

    public LdapException(Exception e, ResultCode code, String dn) {
        super(e);
        this.resultCode = code;
        this.matchedDn = dn;
        this.responseControls = null;
        this.referralURLs = null;
        this.messageId = -1;
    }

    public LdapException(Exception e, ResultCode code, String dn, ResponseControl[] c) {
        super(e);
        this.resultCode = code;
        this.matchedDn = dn;
        this.responseControls = c;
        this.referralURLs = null;
        this.messageId = -1;
    }

    public LdapException(Exception e, ResultCode code, String dn, ResponseControl[] c, String[] urls) {
        super(e);
        this.resultCode = code;
        this.matchedDn = dn;
        this.responseControls = c;
        this.referralURLs = urls;
        this.messageId = -1;
    }

    public LdapException(Exception e, ResultCode code, String dn, ResponseControl[] c, String[] urls, int id) {
        super(e);
        this.resultCode = code;
        this.matchedDn = dn;
        this.responseControls = c;
        this.referralURLs = urls;
        this.messageId = id;
    }

    public LdapException(String msg, Exception e) {
        super(msg, e);
        this.resultCode = null;
        this.matchedDn = null;
        this.responseControls = null;
        this.referralURLs = null;
        this.messageId = -1;
    }

    public LdapException(String msg, Exception e, ResultCode code) {
        super(msg, e);
        this.resultCode = code;
        this.matchedDn = null;
        this.responseControls = null;
        this.referralURLs = null;
        this.messageId = -1;
    }

    public LdapException(String msg, Exception e, ResultCode code, String dn) {
        super(msg, e);
        this.resultCode = code;
        this.matchedDn = dn;
        this.responseControls = null;
        this.referralURLs = null;
        this.messageId = -1;
    }

    public LdapException(String msg, Exception e, ResultCode code, String dn, ResponseControl[] c) {
        super(msg, e);
        this.resultCode = code;
        this.matchedDn = dn;
        this.responseControls = c;
        this.referralURLs = null;
        this.messageId = -1;
    }

    public LdapException(String msg, Exception e, ResultCode code, String dn, ResponseControl[] c, String[] urls) {
        super(msg, e);
        this.resultCode = code;
        this.matchedDn = dn;
        this.responseControls = c;
        this.referralURLs = urls;
        this.messageId = -1;
    }

    public LdapException(String msg, Exception e, ResultCode code, String dn, ResponseControl[] c, String[] urls, int id) {
        super(msg, e);
        this.resultCode = code;
        this.matchedDn = dn;
        this.responseControls = c;
        this.referralURLs = urls;
        this.messageId = id;
    }

    public ResultCode getResultCode() {
        return this.resultCode;
    }

    public String getMatchedDn() {
        return this.matchedDn;
    }

    public ResponseControl[] getControls() {
        return this.responseControls;
    }

    @Override
    public ResponseControl getControl(String oid) {
        if (this.getControls() != null) {
            for (ResponseControl c : this.getControls()) {
                if (!c.getOID().equals(oid)) continue;
                return c;
            }
        }
        return null;
    }

    public String[] getReferralURLs() {
        return this.referralURLs;
    }

    @Override
    public int getMessageId() {
        return this.messageId;
    }

    @Override
    public String toString() {
        return String.format("[%s@%d::resultCode=%s, matchedDn=%s, responseControls=%s, referralURLs=%s, messageId=%s, providerException=%s]", new Object[]{this.getClass().getName(), this.hashCode(), this.resultCode, this.matchedDn, Arrays.toString(this.responseControls), Arrays.toString(this.referralURLs), this.messageId, this.getCause()});
    }
}

