/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.Arrays;
import org.ldaptive.BindRequest;
import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.Operation;
import org.ldaptive.OperationException;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.handler.AbstractRetryOperationExceptionHandler;
import org.ldaptive.handler.Handler;
import org.ldaptive.handler.HandlerResult;
import org.ldaptive.handler.OperationExceptionHandler;
import org.ldaptive.handler.OperationResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperation<Q extends Request, S>
implements Operation<Q, S> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Connection connection;
    private OperationExceptionHandler<Q, S> operationExceptionHandler = new ReopenOperationExceptionHandler();
    private OperationResponseHandler<Q, S>[] operationResponseHandlers;

    public AbstractOperation(Connection conn) {
        this.connection = conn;
    }

    protected Connection getConnection() {
        return this.connection;
    }

    public OperationExceptionHandler<Q, S> getOperationExceptionHandler() {
        return this.operationExceptionHandler;
    }

    public void setOperationExceptionHandler(OperationExceptionHandler<Q, S> handler) {
        this.operationExceptionHandler = handler;
    }

    public OperationResponseHandler<Q, S>[] getOperationResponseHandlers() {
        return this.operationResponseHandlers;
    }

    public void setOperationResponseHandlers(OperationResponseHandler<Q, S> ... handlers) {
        this.operationResponseHandlers = handlers;
    }

    protected abstract Response<S> invoke(Q var1) throws LdapException;

    @Override
    public Response<S> execute(Q request) throws LdapException {
        this.logger.debug("execute request={} with connection={}", request, (Object)this.connection);
        Response<S> response = null;
        try {
            response = this.invoke(request);
        }
        catch (OperationException e) {
            if (this.operationExceptionHandler == null) {
                throw e;
            }
            this.logger.warn("Error performing LDAP operation, invoking exception handler: {}", this.operationExceptionHandler, (Object)e);
            HandlerResult<Response<S>> hr = this.operationExceptionHandler.process(this.connection, request, response);
            if (hr.getAbort()) {
                throw e;
            }
            response = hr.getResult();
        }
        HandlerResult<Response<S>> hr = this.executeHandlers((Handler<Q, S>[])this.getOperationResponseHandlers(), request, (S)response);
        this.logger.debug("execute response={} for request={} with connection={}", new Object[]{hr.getResult(), request, this.connection});
        return hr.getResult();
    }

    protected <Q extends Request, S> HandlerResult<S> executeHandlers(Handler<Q, S>[] handlers, Q request, S result) throws LdapException {
        S processed = result;
        boolean abort = false;
        if (handlers != null && handlers.length > 0) {
            for (Handler<Q, S> handler : handlers) {
                if (handler == null) continue;
                try {
                    HandlerResult<S> hr = handler.process(this.getConnection(), request, processed);
                    if (hr == null) continue;
                    if (hr.getAbort()) {
                        abort = true;
                    }
                    processed = hr.getResult();
                }
                catch (Exception e) {
                    this.logger.warn("{} threw unexpected exception", handler, (Object)e);
                }
            }
        }
        return new HandlerResult<S>(processed, abort);
    }

    public String toString() {
        return String.format("[%s@%d::connection=%s, operationExceptionHandler=%s, operationResponseHandlers=%s]", this.getClass().getName(), this.hashCode(), this.connection, this.operationExceptionHandler, Arrays.toString(this.operationResponseHandlers));
    }

    public class ReopenOperationExceptionHandler
    extends AbstractRetryOperationExceptionHandler<Q, S> {
        private final BindRequest bindRequest;

        public ReopenOperationExceptionHandler() {
            this.bindRequest = null;
        }

        public ReopenOperationExceptionHandler(BindRequest request) {
            this.bindRequest = request;
        }

        @Override
        protected void processInternal(Connection conn, Q request, Response<S> response) throws LdapException {
            if (this.bindRequest != null) {
                conn.reopen(this.bindRequest);
            } else {
                conn.reopen();
            }
        }

        @Override
        protected HandlerResult<Response<S>> createResult(Connection conn, Q request, Response<S> response) throws LdapException {
            return new HandlerResult(AbstractOperation.this.invoke(request));
        }

        public String toString() {
            return String.format("[%s@%d::retry=%s, retryWait=%s, retryBackoff=%s, bindRequest=%s]", this.getClass().getName(), this.hashCode(), this.getRetry(), this.getRetryWait(), this.getRetryBackoff(), this.bindRequest);
        }
    }
}

