/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.xml;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.w3c.dom.ls.LSSerializerFilter;

public final class SerializeSupport {
    private SerializeSupport() {
    }

    @Nonnull
    public static String nodeToString(@Nonnull Node node) {
        Constraint.isNotNull(node, "Node may not be null");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        SerializeSupport.writeNode(node, baout);
        try {
            return new String(baout.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static String prettyPrintXML(@Nonnull Node node) {
        Constraint.isNotNull(node, "Node may not be null");
        TransformerFactory tfactory = TransformerFactory.newInstance();
        try {
            Transformer serializer = tfactory.newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
            StringWriter output = new StringWriter();
            serializer.transform(new DOMSource(node), new StreamResult(output));
            return output.toString();
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void writeNode(@Nonnull Node node, @Nonnull OutputStream output) {
        Constraint.isNotNull(node, "Node may not be null");
        Constraint.isNotNull(output, "Outputstream may not be null");
        DOMImplementationLS domImplLS = SerializeSupport.getDomLsImplementation(node);
        LSSerializer serializer = domImplLS.createLSSerializer();
        serializer.setFilter(new LSSerializerFilter(){

            @Override
            public short acceptNode(Node arg0) {
                return 1;
            }

            @Override
            public int getWhatToShow() {
                return -1;
            }
        });
        LSOutput serializerOut = domImplLS.createLSOutput();
        serializerOut.setByteStream(output);
        serializer.write(node, serializerOut);
    }

    @Nonnull
    public static LSSerializer getLsSerializer(@Nonnull DOMImplementationLS domImplLS, @Nullable Map<String, Object> serializerParams) {
        Constraint.isNotNull(domImplLS, "DOM implementation can not be null");
        LSSerializer serializer = domImplLS.createLSSerializer();
        serializer.setFilter(new LSSerializerFilter(){

            @Override
            public short acceptNode(Node arg0) {
                return 1;
            }

            @Override
            public int getWhatToShow() {
                return -1;
            }
        });
        if (serializerParams != null) {
            DOMConfiguration serializerDOMConfig = serializer.getDomConfig();
            for (String key : serializerParams.keySet()) {
                serializerDOMConfig.setParameter(key, serializerParams.get(key));
            }
        }
        return serializer;
    }

    @Nonnull
    public static DOMImplementationLS getDomLsImplementation(@Nonnull Node node) {
        Constraint.isNotNull(node, "DOM node can not be null");
        DOMImplementation domImpl = node instanceof Document ? ((Document)node).getImplementation() : node.getOwnerDocument().getImplementation();
        return (DOMImplementationLS)domImpl.getFeature("LS", "3.0");
    }
}

