/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.client.http;

import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

@NotThreadSafe
public class HttpClientBuilder {
    private String proxyHost;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private boolean preemptiveAuthentication;
    private String contentCharSet;
    private int connectionTimeout;
    private int sendBufferSize;
    private int receiveBufferSize;
    private boolean tcpNoDelay;
    private int maxConnectionsPerHost;
    private int maxTotalConnectons;
    private int connectionRetryAttempts;
    private SecureProtocolSocketFactory httpsProtocolSocketFactory;

    public HttpClientBuilder() {
        this.resetDefaults();
    }

    public void resetDefaults() {
        this.proxyPort = -1;
        this.preemptiveAuthentication = false;
        this.contentCharSet = "UTF-8";
        this.connectionTimeout = 5000;
        this.sendBufferSize = 4096;
        this.receiveBufferSize = 16384;
        this.tcpNoDelay = true;
        this.maxConnectionsPerHost = 5;
        this.maxTotalConnectons = 20;
        this.connectionRetryAttempts = 0;
    }

    public HttpClient buildClient() {
        if (this.httpsProtocolSocketFactory != null) {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", this.httpsProtocolSocketFactory, 443));
        }
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setAuthenticationPreemptive(this.isPreemptiveAuthentication());
        clientParams.setContentCharset(this.getContentCharSet());
        clientParams.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(this.connectionRetryAttempts, false));
        HttpConnectionManagerParams connMgrParams = new HttpConnectionManagerParams();
        connMgrParams.setConnectionTimeout(this.getConnectionTimeout());
        connMgrParams.setDefaultMaxConnectionsPerHost(this.getMaxConnectionsPerHost());
        connMgrParams.setMaxTotalConnections(this.getMaxTotalConnections());
        connMgrParams.setReceiveBufferSize(this.getReceiveBufferSize());
        connMgrParams.setSendBufferSize(this.getSendBufferSize());
        connMgrParams.setTcpNoDelay(this.isTcpNoDelay());
        MultiThreadedHttpConnectionManager connMgr = new MultiThreadedHttpConnectionManager();
        connMgr.setParams(connMgrParams);
        HttpClient httpClient = new HttpClient(clientParams, (HttpConnectionManager)connMgr);
        if (this.proxyHost != null) {
            HostConfiguration hostConfig = new HostConfiguration();
            hostConfig.setProxy(this.proxyHost, this.proxyPort);
            httpClient.setHostConfiguration(hostConfig);
            if (this.proxyUsername != null) {
                AuthScope proxyAuthScope = new AuthScope(this.proxyHost, this.proxyPort);
                UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword);
                httpClient.getState().setProxyCredentials(proxyAuthScope, (Credentials)proxyCredentials);
            }
        }
        return httpClient;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String host) {
        this.proxyHost = StringSupport.trimOrNull((String)host);
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int port) {
        this.proxyPort = port;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String username) {
        this.proxyUsername = StringSupport.trimOrNull((String)username);
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String password) {
        this.proxyPassword = StringSupport.trimOrNull((String)password);
    }

    public boolean isPreemptiveAuthentication() {
        return this.preemptiveAuthentication;
    }

    public void setPreemptiveAuthentication(boolean preemptive) {
        this.preemptiveAuthentication = preemptive;
    }

    public String getContentCharSet() {
        return this.contentCharSet;
    }

    public void setContentCharSet(String charSet) {
        this.contentCharSet = charSet;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int size) {
        this.sendBufferSize = size;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int size) {
        this.receiveBufferSize = size;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean noDelay) {
        this.tcpNoDelay = noDelay;
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public void setMaxConnectionsPerHost(int max) {
        this.maxConnectionsPerHost = max;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnectons;
    }

    public void setMaxTotalConnections(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Maximum total number of connections must be greater than zero.");
        }
        this.maxTotalConnectons = max;
    }

    public int getConnectionRetryAttempts() {
        return this.connectionRetryAttempts;
    }

    public void setConnectionRetryAttempts(int attempts) {
        this.connectionRetryAttempts = attempts;
    }

    public SecureProtocolSocketFactory getHttpsProtocolSocketFactory() {
        return this.httpsProtocolSocketFactory;
    }

    public void setHttpsProtocolSocketFactory(SecureProtocolSocketFactory factory) {
        this.httpsProtocolSocketFactory = factory;
    }
}

