/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.artifact;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BasicMessageMetadataContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.BasicEndpointSelector;
import org.opensaml.saml.common.context.SamlLocalEntityContext;
import org.opensaml.saml.common.context.SamlMetadataContext;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactBuilder;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.opensaml.saml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IndexedEndpoint;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.provider.MetadataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2ArtifactType0004Builder
implements SAML2ArtifactBuilder<SAML2ArtifactType0004> {
    private final Logger log = LoggerFactory.getLogger(SAML2ArtifactType0004Builder.class);

    @Override
    public SAML2ArtifactType0004 buildArtifact(byte[] artifact) {
        return SAML2ArtifactType0004.parseArtifact(artifact);
    }

    @Override
    public SAML2ArtifactType0004 buildArtifact(MessageContext<SAMLObject> requestContext) {
        try {
            IndexedEndpoint acsEndpoint = (IndexedEndpoint)this.getAcsEndpoint(requestContext);
            if (acsEndpoint == null) {
                return null;
            }
            byte[] endpointIndex = this.intToByteArray(acsEndpoint.getIndex());
            byte[] trimmedIndex = new byte[]{endpointIndex[2], endpointIndex[3]};
            MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
            byte[] source = sha1Digester.digest(this.getLocalEntityId(requestContext).getBytes());
            SecureRandom handleGenerator = SecureRandom.getInstance("SHA1PRNG");
            byte[] assertionHandle = new byte[20];
            handleGenerator.nextBytes(assertionHandle);
            return new SAML2ArtifactType0004(trimmedIndex, source, assertionHandle);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("JVM does not support required cryptography algorithms: SHA-1/SHA1PRNG.", (Throwable)e);
            throw new InternalError("JVM does not support required cryptography algorithms: SHA-1/SHA1PRNG.");
        }
    }

    protected Endpoint getAcsEndpoint(MessageContext<SAMLObject> requestContext) {
        BasicEndpointSelector selector = new BasicEndpointSelector();
        selector.setEndpointType(ArtifactResolutionService.DEFAULT_ELEMENT_NAME);
        selector.getSupportedIssuerBindings().add("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        selector.setMetadataProvider(this.getMetadataProvider(requestContext));
        selector.setEntityMetadata(this.getLocalEntityMetadata(requestContext));
        selector.setEntityRoleMetadata(this.getLocalEntityRoleMetadata(requestContext));
        Endpoint acsEndpoint = selector.selectEndpoint();
        if (acsEndpoint == null) {
            this.log.error("No artifact resolution service endpoint defined for the entity " + this.getOutboundMessageIssuer(requestContext));
            return null;
        }
        return acsEndpoint;
    }

    private String getLocalEntityId(MessageContext<SAMLObject> requestContext) {
        SamlLocalEntityContext localContext = (SamlLocalEntityContext)requestContext.getSubcontext(SamlLocalEntityContext.class, false);
        Constraint.isNotNull((Object)((Object)localContext), (String)"Message context did not contain a LocalEntityContext");
        Constraint.isNotNull((Object)localContext.getEntityId(), (String)"LocalEntityContext contained a null entityId");
        return localContext.getEntityId();
    }

    private String getOutboundMessageIssuer(MessageContext<SAMLObject> requestContext) {
        BasicMessageMetadataContext basicContext = (BasicMessageMetadataContext)requestContext.getSubcontext(BasicMessageMetadataContext.class, false);
        Constraint.isNotNull((Object)basicContext, (String)"Message context did not contain a BasicMessageMetadataContext");
        return basicContext.getMessageIssuer();
    }

    private RoleDescriptor getLocalEntityRoleMetadata(MessageContext<SAMLObject> requestContext) {
        SamlLocalEntityContext localContext = (SamlLocalEntityContext)requestContext.getSubcontext(SamlLocalEntityContext.class, false);
        Constraint.isNotNull((Object)((Object)localContext), (String)"Message context did not contain a LocalEntityContext");
        SamlMetadataContext mdContext = (SamlMetadataContext)localContext.getSubcontext(SamlMetadataContext.class, false);
        Constraint.isNotNull((Object)((Object)mdContext), (String)"LocalEntityContext did not contain a SamlMetadataContext");
        return mdContext.getRoleDescriptor();
    }

    private EntityDescriptor getLocalEntityMetadata(MessageContext<SAMLObject> requestContext) {
        SamlLocalEntityContext localContext = (SamlLocalEntityContext)requestContext.getSubcontext(SamlLocalEntityContext.class, false);
        Constraint.isNotNull((Object)((Object)localContext), (String)"Message context did not contain a LocalEntityContext");
        SamlMetadataContext mdContext = (SamlMetadataContext)localContext.getSubcontext(SamlMetadataContext.class, false);
        Constraint.isNotNull((Object)((Object)mdContext), (String)"LocalEntityContext did not contain a SamlMetadataContext");
        return mdContext.getEntityDescriptor();
    }

    private MetadataProvider getMetadataProvider(MessageContext<SAMLObject> requestContext) {
        return null;
    }

    private byte[] intToByteArray(int integer) {
        byte[] intBytes = new byte[]{(byte)((integer & 0xFF000000) >>> 24), (byte)((integer & 0xFF0000) >>> 16), (byte)((integer & 0xFF00) >>> 8), (byte)(integer & 0xFF)};
        return intBytes;
    }
}

