/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.common.binding.BasicEndpointSelector;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IndexedEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthnResponseEndpointSelector
extends BasicEndpointSelector {
    private final Logger log = LoggerFactory.getLogger(AuthnResponseEndpointSelector.class);

    @Override
    public Endpoint selectEndpoint() {
        if (this.getEntityRoleMetadata() == null) {
            this.log.debug("Unable to select endpoint, no entity role metadata available.");
            return null;
        }
        List<Endpoint> endpoints = this.getEntityRoleMetadata().getEndpoints(this.getEndpointType());
        if (endpoints == null || endpoints.size() == 0) {
            return null;
        }
        Endpoint endpoint = null;
        AuthnRequest request = (AuthnRequest)this.getSamlRequest();
        if (request != null) {
            if ((endpoints = this.filterEndpointsByProtocolBinding(endpoints)) == null || endpoints.isEmpty()) {
                return null;
            }
            if (request.getAssertionConsumerServiceIndex() != null) {
                this.log.debug("Selecting endpoint by ACS index '{}' for request '{}' from entity '{}'", new Object[]{request.getAssertionConsumerServiceIndex(), request.getID(), this.getEntityMetadata().getEntityID()});
                endpoint = this.selectEndpointByACSIndex(request, endpoints);
            } else if (request.getAssertionConsumerServiceURL() != null) {
                this.log.debug("Selecting endpoint by ACS URL '{}' and protocol binding '{}' for request '{}' from entity '{}'", new Object[]{request.getAssertionConsumerServiceURL(), request.getProtocolBinding(), request.getID(), this.getEntityMetadata().getEntityID()});
                endpoint = this.selectEndpointByACSURL(request, endpoints);
            }
        }
        if (endpoint == null && request.getAssertionConsumerServiceIndex() == null && request.getAssertionConsumerServiceURL() == null) {
            this.log.debug("No ACS index or URL given, selecting endpoint without additional constraints.");
            endpoint = endpoints.get(0) instanceof IndexedEndpoint ? this.selectIndexedEndpoint(endpoints) : this.selectNonIndexedEndpoint(endpoints);
        }
        return endpoint;
    }

    @Override
    protected List<? extends Endpoint> filterEndpointsByProtocolBinding(List<? extends Endpoint> endpoints) {
        this.log.debug("Filtering peer endpoints.  Supported peer endpoint bindings: {}", this.getSupportedIssuerBindings());
        AuthnRequest request = (AuthnRequest)this.getSamlRequest();
        boolean filterByRequestBinding = false;
        String acsBinding = StringSupport.trimOrNull((String)request.getProtocolBinding());
        if (acsBinding != null && request.getAssertionConsumerServiceIndex() != null) {
            filterByRequestBinding = true;
        }
        ArrayList<? extends Endpoint> filteredEndpoints = new ArrayList<Endpoint>(endpoints);
        Iterator endpointItr = filteredEndpoints.iterator();
        while (endpointItr.hasNext()) {
            Endpoint endpoint = (Endpoint)endpointItr.next();
            if (!this.getSupportedIssuerBindings().contains(endpoint.getBinding())) {
                this.log.debug("Removing endpoint {} because its binding {} is not supported", (Object)endpoint.getLocation(), (Object)endpoint.getBinding());
                endpointItr.remove();
                continue;
            }
            if (!filterByRequestBinding || endpoint.getBinding().equals(acsBinding)) continue;
            this.log.debug("Removing endpoint {} because its binding {} does not match request's requested binding", (Object)endpoint.getLocation(), (Object)endpoint.getBinding());
            endpointItr.remove();
        }
        return filteredEndpoints;
    }

    protected Endpoint selectEndpointByACSIndex(AuthnRequest request, List<IndexedEndpoint> endpoints) {
        Integer acsIndex = request.getAssertionConsumerServiceIndex();
        for (IndexedEndpoint endpoint : endpoints) {
            if (endpoint == null || !this.getSupportedIssuerBindings().contains(endpoint.getBinding())) {
                this.log.debug("Endpoint '{}' with binding '{}' discarded because it requires an unsupported outbound binding.", (Object)endpoint.getLocation(), (Object)endpoint.getBinding());
                continue;
            }
            if (Objects.equal((Object)acsIndex, (Object)endpoint.getIndex())) {
                return endpoint;
            }
            this.log.debug("Endpoint '{}' with index '{}' discard because it does have the required index '{}'", new Object[]{endpoint.getLocation(), endpoint.getIndex(), acsIndex});
        }
        this.log.warn("Relying party '{}' requested the response to be returned to endpoint with ACS index '{}' however no endpoint, with that index and using a supported binding, can be found  in the relying party's metadata ", (Object)this.getEntityMetadata().getEntityID(), (Object)acsIndex);
        return null;
    }

    protected Endpoint selectEndpointByACSURL(AuthnRequest request, List<IndexedEndpoint> endpoints) {
        String acsBinding = StringSupport.trimOrNull((String)request.getProtocolBinding());
        for (IndexedEndpoint endpoint : endpoints) {
            if (!this.getSupportedIssuerBindings().contains(endpoint.getBinding())) {
                this.log.debug("Endpoint '{}' with binding '{}' discarded because that is not a supported outbound binding.", (Object)endpoint.getLocation(), (Object)endpoint.getBinding());
                continue;
            }
            if (acsBinding != null && !Objects.equal((Object)acsBinding, (Object)endpoint.getBinding())) {
                this.log.debug("Endpoint '{}' with binding '{}' discarded because it does not meet protocol binding selection criteria", (Object)endpoint.getLocation(), (Object)endpoint.getBinding());
                continue;
            }
            if (Objects.equal((Object)endpoint.getLocation(), (Object)request.getAssertionConsumerServiceURL()) || Objects.equal((Object)endpoint.getResponseLocation(), (Object)request.getAssertionConsumerServiceURL())) {
                return endpoint;
            }
            this.log.debug("Endpoint '{}' discarded because neither its Location nor ResponseLocation match ACS URL '{}'", (Object)endpoint.getLocation(), (Object)request.getAssertionConsumerServiceURL());
        }
        this.log.warn("Relying party '{}' requested the response to be returned to endpoint with ACS URL '{}'  and binding '{}' however no endpoint, with that URL and using a supported binding,  can be found in the relying party's metadata ", new Object[]{this.getEntityMetadata().getEntityID(), request.getAssertionConsumerServiceURL(), acsBinding == null ? "any" : acsBinding});
        return null;
    }
}

