/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.binding.artifact;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.BasicEndpointSelector;
import org.opensaml.saml.common.context.SamlLocalEntityContext;
import org.opensaml.saml.common.context.SamlMetadataContext;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactBuilder;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactType0002;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.provider.MetadataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML1ArtifactType0002Builder
implements SAML1ArtifactBuilder<SAML1ArtifactType0002> {
    private final Logger log = LoggerFactory.getLogger(SAML1ArtifactType0002Builder.class);

    @Override
    public SAML1ArtifactType0002 buildArtifact(byte[] artifact) {
        return SAML1ArtifactType0002.parseArtifact(artifact);
    }

    @Override
    public SAML1ArtifactType0002 buildArtifact(MessageContext<SAMLObject> requestContext, Assertion assertion) {
        try {
            String sourceLocation = this.getSourceLocation(requestContext);
            if (sourceLocation == null) {
                return null;
            }
            SecureRandom handleGenerator = SecureRandom.getInstance("SHA1PRNG");
            byte[] assertionHandle = new byte[20];
            handleGenerator.nextBytes(assertionHandle);
            return new SAML1ArtifactType0002(assertionHandle, sourceLocation);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("JVM does not support required cryptography algorithms: SHA1PRNG.", (Throwable)e);
            throw new InternalError("JVM does not support required cryptography algorithms: SHA1PRNG.");
        }
    }

    protected String getSourceLocation(MessageContext<SAMLObject> requestContext) {
        BasicEndpointSelector selector = new BasicEndpointSelector();
        selector.setEndpointType(ArtifactResolutionService.DEFAULT_ELEMENT_NAME);
        selector.getSupportedIssuerBindings().add("urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
        selector.setMetadataProvider(this.getMetadataProvider(requestContext));
        selector.setEntityMetadata(this.getLocalEntityMetadata(requestContext));
        selector.setEntityRoleMetadata(this.getLocalEntityRoleMetadata(requestContext));
        Endpoint acsEndpoint = selector.selectEndpoint();
        if (acsEndpoint == null) {
            this.log.error("Unable to select source location for artifact.  No artifact resolution service defined for issuer.");
            return null;
        }
        return acsEndpoint.getLocation();
    }

    private RoleDescriptor getLocalEntityRoleMetadata(MessageContext<SAMLObject> requestContext) {
        SamlLocalEntityContext localContext = (SamlLocalEntityContext)requestContext.getSubcontext(SamlLocalEntityContext.class, false);
        Constraint.isNotNull((Object)((Object)localContext), (String)"Message context did not contain a LocalEntityContext");
        SamlMetadataContext mdContext = (SamlMetadataContext)localContext.getSubcontext(SamlMetadataContext.class, false);
        Constraint.isNotNull((Object)((Object)mdContext), (String)"LocalEntityContext did not contain a SamlMetadataContext");
        return mdContext.getRoleDescriptor();
    }

    private EntityDescriptor getLocalEntityMetadata(MessageContext<SAMLObject> requestContext) {
        SamlLocalEntityContext localContext = (SamlLocalEntityContext)requestContext.getSubcontext(SamlLocalEntityContext.class, false);
        Constraint.isNotNull((Object)((Object)localContext), (String)"Message context did not contain a LocalEntityContext");
        SamlMetadataContext mdContext = (SamlMetadataContext)localContext.getSubcontext(SamlMetadataContext.class, false);
        Constraint.isNotNull((Object)((Object)mdContext), (String)"LocalEntityContext did not contain a SamlMetadataContext");
        return mdContext.getEntityDescriptor();
    }

    private MetadataProvider getMetadataProvider(MessageContext<SAMLObject> requestContext) {
        return null;
    }
}

