/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.binding.artifact;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.context.SamlLocalEntityContext;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactBuilder;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactType0001;
import org.opensaml.saml.saml1.core.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML1ArtifactType0001Builder
implements SAML1ArtifactBuilder<SAML1ArtifactType0001> {
    private final Logger log = LoggerFactory.getLogger(SAML1ArtifactType0001Builder.class);

    @Override
    public SAML1ArtifactType0001 buildArtifact(byte[] artifact) {
        return SAML1ArtifactType0001.parseArtifact(artifact);
    }

    @Override
    public SAML1ArtifactType0001 buildArtifact(MessageContext<SAMLObject> requestContext, Assertion assertion) {
        try {
            MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
            byte[] source = sha1Digester.digest(this.getLocalEntityId(requestContext).getBytes());
            SecureRandom handleGenerator = SecureRandom.getInstance("SHA1PRNG");
            byte[] assertionHandle = new byte[20];
            handleGenerator.nextBytes(assertionHandle);
            return new SAML1ArtifactType0001(source, assertionHandle);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("JVM does not support required cryptography algorithms.", (Throwable)e);
            throw new InternalError("JVM does not support required cryptography algorithms: SHA-1 and/or SHA1PRNG.");
        }
    }

    private String getLocalEntityId(MessageContext<SAMLObject> requestContext) {
        SamlLocalEntityContext localContext = (SamlLocalEntityContext)requestContext.getSubcontext(SamlLocalEntityContext.class, false);
        Constraint.isNotNull((Object)((Object)localContext), (String)"Message context did not contain a LocalEntityContext");
        Constraint.isNotNull((Object)localContext.getEntityId(), (String)"LocalEntityContext contained a null entityId");
        return localContext.getEntityId();
    }
}

