/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.decoding;

import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.SAMLMessageContext;
import org.opensaml.saml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.security.SecurityException;
import org.opensaml.ws.message.decoder.BaseMessageDecoder;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSAMLMessageDecoder
extends BaseMessageDecoder
implements SAMLMessageDecoder {
    private final Logger log = LoggerFactory.getLogger(BaseSAMLMessageDecoder.class);

    public BaseSAMLMessageDecoder() {
    }

    public BaseSAMLMessageDecoder(ParserPool pool) {
        super(pool);
    }

    protected boolean isMessageSigned(SAMLMessageContext messageContext) {
        Object samlMessage = messageContext.getInboundSAMLMessage();
        if (samlMessage instanceof SignableSAMLObject) {
            return ((SignableSAMLObject)samlMessage).isSigned();
        }
        return false;
    }

    protected abstract boolean isIntendedDestinationEndpointURIRequired(SAMLMessageContext var1);

    protected abstract String getIntendedDestinationEndpointURI(SAMLMessageContext var1) throws MessageDecodingException;

    protected String getActualReceiverEndpointURI(SAMLMessageContext messageContext) throws MessageDecodingException {
        InTransport inTransport = messageContext.getInboundMessageTransport();
        if (!(inTransport instanceof HttpServletRequestAdapter)) {
            this.log.error("Message context InTransport instance was an unsupported type: {}", (Object)inTransport.getClass().getName());
            throw new MessageDecodingException("Message context InTransport instance was an unsupported type");
        }
        HttpServletRequest httpRequest = ((HttpServletRequestAdapter)inTransport).getWrappedRequest();
        StringBuffer urlBuilder = httpRequest.getRequestURL();
        return urlBuilder.toString();
    }

    protected boolean compareEndpointURIs(String messageDestination, String receiverEndpoint) throws MessageDecodingException {
        return false;
    }

    protected void checkEndpointURI(SAMLMessageContext messageContext) throws SecurityException, MessageDecodingException {
    }
}

