/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.artifact;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLRuntimeException;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.artifact.BasicSAMLArtifactMapEntry;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;

public class BasicSAMLArtifactMapEntryFactory
implements SAMLArtifactMap.SAMLArtifactMapEntryFactory {
    private boolean serializeMessage;

    public void setSerializeMessage(boolean newSerializeMessage) {
        this.serializeMessage = newSerializeMessage;
    }

    public boolean isSerializeMessage() {
        return this.serializeMessage;
    }

    @Override
    public SAMLArtifactMap.SAMLArtifactMapEntry newEntry(String artifact, String issuerId, String relyingPartyId, SAMLObject samlMessage, long lifetime) {
        SAMLObject newSAMLMessage = this.getStorableSAMLMessage(samlMessage);
        BasicSAMLArtifactMapEntry entry = new BasicSAMLArtifactMapEntry(artifact, issuerId, relyingPartyId, newSAMLMessage, lifetime);
        if (this.serializeMessage) {
            entry.serializeMessage();
        }
        return entry;
    }

    private SAMLObject getStorableSAMLMessage(SAMLObject samlMessage) {
        if (!samlMessage.hasParent()) {
            return samlMessage;
        }
        try {
            return (SAMLObject)XMLObjectSupport.cloneXMLObject((XMLObject)samlMessage, (boolean)true);
        }
        catch (MarshallingException e) {
            throw new XMLRuntimeException("Error during marshalling of SAMLObject", (Exception)((Object)e));
        }
        catch (UnmarshallingException e) {
            throw new XMLRuntimeException("Error during unmarshalling of SAMLObject", (Exception)((Object)e));
        }
    }
}

