/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.artifact;

import java.util.Arrays;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import org.apache.commons.codec.binary.Hex;

public abstract class AbstractSAMLArtifact {
    private byte[] typeCode;

    protected AbstractSAMLArtifact(byte[] code) {
        if (code.length != 2) {
            throw new IllegalArgumentException("Type code was not 2-bytes in size");
        }
        this.typeCode = code;
    }

    public byte[] getArtifactBytes() {
        byte[] remainingArtifact = this.getRemainingArtifact();
        byte[] artifact = new byte[2 + remainingArtifact.length];
        System.arraycopy(this.getTypeCode(), 0, artifact, 0, 2);
        System.arraycopy(remainingArtifact, 0, artifact, 2, remainingArtifact.length);
        return artifact;
    }

    public byte[] getTypeCode() {
        return this.typeCode;
    }

    protected void setTypeCode(byte[] newTypeCode) {
        this.typeCode = newTypeCode;
    }

    public abstract byte[] getRemainingArtifact();

    public String base64Encode() {
        return Base64Support.encode((byte[])this.getArtifactBytes(), (boolean)false);
    }

    public String hexEncode() {
        return Hex.encodeHexString((byte[])this.getArtifactBytes());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AbstractSAMLArtifact) {
            AbstractSAMLArtifact otherArtifact = (AbstractSAMLArtifact)o;
            return Arrays.equals(this.getArtifactBytes(), otherArtifact.getArtifactBytes());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getArtifactBytes());
    }

    public String toString() {
        return this.base64Encode();
    }
}

