/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding;

import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.BindingException;
import org.opensaml.saml.common.context.SamlEndpointContext;
import org.opensaml.saml.common.context.SamlPeerEntityContext;
import org.opensaml.saml.common.context.SamlProtocolContext;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SAMLBindingSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SAMLBindingSupport.class);

    private SAMLBindingSupport() {
    }

    public static String getRelayState(MessageContext<SAMLObject> messageContext) {
        SamlProtocolContext protocolContext = (SamlProtocolContext)messageContext.getSubcontext(SamlProtocolContext.class);
        if (protocolContext == null) {
            return null;
        }
        return protocolContext.getRelayState();
    }

    public static boolean checkRelayState(String relayState) {
        if (!Strings.isNullOrEmpty((String)relayState)) {
            if (relayState.getBytes().length > 80) {
                LOG.warn("Relay state exceeds 80 bytes, some application may not support this.");
            }
            return true;
        }
        return false;
    }

    public static URI getEndpointURL(MessageContext<SAMLObject> messageContext) throws BindingException {
        SamlPeerEntityContext peerContext = (SamlPeerEntityContext)messageContext.getSubcontext(SamlPeerEntityContext.class, false);
        Constraint.isNotNull((Object)((Object)peerContext), (String)"Message context contained no PeerEntityContext");
        SamlEndpointContext endpointContext = (SamlEndpointContext)peerContext.getSubcontext(SamlEndpointContext.class, false);
        Constraint.isNotNull((Object)((Object)endpointContext), (String)"PeerEntityContext contained no SamlEndpointContext");
        Endpoint endpoint = endpointContext.getEndpoint();
        if (endpoint == null) {
            throw new BindingException("Endpoint for relying party was null.");
        }
        SAMLObject message = (SAMLObject)messageContext.getMessage();
        if ((message instanceof StatusResponseType || message instanceof Response) && !Strings.isNullOrEmpty((String)endpoint.getResponseLocation())) {
            try {
                return new URI(endpoint.getResponseLocation());
            }
            catch (URISyntaxException e) {
                throw new BindingException("The endpoint response location " + endpoint.getResponseLocation() + " is not a valid URL", e);
            }
        }
        if (Strings.isNullOrEmpty((String)endpoint.getLocation())) {
            throw new BindingException("Relying party endpoint location was null or empty.");
        }
        try {
            return new URI(endpoint.getLocation());
        }
        catch (URISyntaxException e) {
            throw new BindingException("The endpoint location " + endpoint.getLocation() + " is not a valid URL", e);
        }
    }
}

