/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.x509.caclient.impl;

import com.novosec.pkix.asn1.cmp.CertRepMessage;
import com.novosec.pkix.asn1.cmp.CertResponse;
import com.novosec.pkix.asn1.cmp.PKIMessage;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import org.apache.http.HttpResponse;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.glite.sts.x509.caclient.CAClientException;
import org.glite.sts.x509.caclient.CAResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMPResponse
implements CAResponse {
    private static Logger log = LoggerFactory.getLogger(CMPResponse.class);
    private PKIMessage pkiMessage;

    public CMPResponse(HttpResponse caResponse) throws CAClientException {
        if (caResponse == null) {
            throw new CAClientException("The response was empty!");
        }
        try {
            InputStream input = caResponse.getEntity().getContent();
            ASN1InputStream asn1input = new ASN1InputStream(input);
            this.pkiMessage = PKIMessage.getInstance((Object)asn1input.readObject());
            asn1input.close();
        }
        catch (IOException e) {
            log.error("Error while creating PKIMessage object!", (Throwable)e);
        }
    }

    @Override
    public X509Certificate getCertificate() {
        CertRepMessage certRepMessage = this.pkiMessage.getBody().getCp();
        if (certRepMessage == null) {
            log.error("No certificates found from the response!");
            return null;
        }
        CertResponse certResp = certRepMessage.getResponse(0);
        if (certResp == null || certResp.getCertifiedKeyPair() == null || certResp.getCertifiedKeyPair().getCertOrEncCert() == null || certResp.getCertifiedKeyPair().getCertOrEncCert().getCertificate() == null) {
            log.error("No certificates found from the response!");
            return null;
        }
        X509CertificateStructure certSt = certResp.getCertifiedKeyPair().getCertOrEncCert().getCertificate();
        X509CertificateObject certObject = null;
        try {
            certObject = new X509CertificateObject(certSt);
        }
        catch (Exception e) {
            log.error("Error while creating certObject: " + e);
            return null;
        }
        X509CertificateObject cert = certObject;
        log.debug("Returning a certificate: {}", (Object)cert.toString());
        return cert;
    }
}

