/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.x509.caclient.impl;

import com.novosec.pkix.asn1.cmp.PKIBody;
import com.novosec.pkix.asn1.cmp.PKIHeader;
import com.novosec.pkix.asn1.cmp.PKIMessage;
import com.novosec.pkix.asn1.crmf.CertReqMessages;
import com.novosec.pkix.asn1.crmf.CertReqMsg;
import com.novosec.pkix.asn1.crmf.CertRequest;
import com.novosec.pkix.asn1.crmf.CertTemplate;
import com.novosec.pkix.asn1.crmf.OptionalValidity;
import com.novosec.pkix.asn1.crmf.PBMParameter;
import com.novosec.pkix.asn1.crmf.ProofOfPossession;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Properties;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.X509Name;
import org.glite.sts.ta.x509.X509TokenGenerationContext;
import org.glite.sts.x509.CertificateExtension;
import org.glite.sts.x509.CertificateKeys;
import org.glite.sts.x509.caclient.CARequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMPRequest
implements CARequest {
    private static final int REQUEST_ID_MAXIMUM = 640000000;
    private static Logger log = LoggerFactory.getLogger(CMPRequest.class);
    private CertificateKeys certKeys;
    private String subjectDN;
    private PKIMessage pkiMessage;
    private Properties cmpProperties;

    public CMPRequest(X509TokenGenerationContext context, Properties cmpProperties) {
        this.cmpProperties = cmpProperties;
        Iterator<CertificateExtension> extensions = context.getExtensions().iterator();
        while (extensions.hasNext()) {
            this.addCertificateExtension(extensions.next());
        }
        this.setSubjectDN(context.getSubjectDN());
        this.setCertificateKeys(context.getCertKeys());
    }

    public void setCertificateKeys(CertificateKeys keys) {
        this.certKeys = keys;
        String issuerDN = this.cmpProperties.getProperty("caDn");
        CertTemplate certTemplate = this.makeCertTemplate(issuerDN);
        int requestId = CMPRequest.makeRandomInt(640000000);
        log.debug("Constructing CMP CertRequest with id=" + requestId);
        CertRequest cmpCertRequest = new CertRequest(new DERInteger(requestId), certTemplate);
        CertReqMsg cmpCertReqMsg = new CertReqMsg(cmpCertRequest);
        ProofOfPossession pop = new ProofOfPossession((DEREncodable)new DERNull(), 0);
        cmpCertReqMsg.setPop(pop);
        CertReqMessages cmpCertReqMessages = new CertReqMessages(cmpCertReqMsg);
        PKIBody pkiBody = new PKIBody((DEREncodable)cmpCertReqMessages, 2);
        String saltStr = this.cmpProperties.getProperty("saltString");
        String owfAlgIdStr = this.cmpProperties.getProperty("owfAlgId");
        String macAlgIdStr = this.cmpProperties.getProperty("macAlgId");
        String iterCountStr = this.cmpProperties.getProperty("iterCount");
        String senderDN = this.cmpProperties.getProperty("senderDn");
        String recipientDN = this.cmpProperties.getProperty("recipientDn");
        String sharedSecret = this.cmpProperties.getProperty("sharedSecret");
        String senderKID = this.cmpProperties.getProperty("senderKid");
        String protectionAlgIdStr = this.cmpProperties.getProperty("protectionAlgId");
        int iterCountInt = new Integer(iterCountStr);
        DEROctetString salt = new DEROctetString(saltStr.getBytes());
        PKIHeader pkiHeader = CMPRequest.makePKIHeader(senderDN, recipientDN, senderKID, salt, owfAlgIdStr, macAlgIdStr, iterCountInt, protectionAlgIdStr);
        this.pkiMessage = new PKIMessage(pkiHeader, pkiBody);
        byte[] protectionBytes = CMPRequest.makeProtection(sharedSecret, iterCountInt, owfAlgIdStr, macAlgIdStr, salt, this.pkiMessage);
        this.pkiMessage.setProtection(new DERBitString(protectionBytes));
        log.debug("pkiMessage = " + this.pkiMessage.toString());
    }

    @Override
    public byte[] getDEREncoded() {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        DEROutputStream out = new DEROutputStream((OutputStream)bao);
        try {
            out.writeObject((Object)this.pkiMessage);
            out.close();
        }
        catch (IOException e) {
            log.error("IOException caught while DER-encoding PKIMessage! " + e.getMessage());
        }
        return bao.toByteArray();
    }

    public void addCertificateExtension(CertificateExtension extension) {
        log.warn("No certificate extensions supported at the moment, skipping one..");
    }

    public void setSubjectDN(String subjectDN) {
        this.subjectDN = subjectDN;
    }

    private CertTemplate makeCertTemplate(String issuerDN) {
        PublicKey publicKey = this.certKeys.getPublicKey();
        ASN1Sequence seq = null;
        try {
            seq = (ASN1Sequence)ASN1Object.fromByteArray((byte[])publicKey.getEncoded());
        }
        catch (IOException e) {
            log.error("Error while decoding the public key", (Throwable)e);
        }
        SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo(seq);
        log.debug("Constructing CMP CertTemplate...");
        CertTemplate certTemplate = new CertTemplate();
        certTemplate.setPublicKey(publicKeyInfo);
        certTemplate.setSubject(new X509Name(this.subjectDN));
        certTemplate.setIssuer(new X509Name(issuerDN));
        OptionalValidity validity = new OptionalValidity();
        GregorianCalendar date = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        date.add(12, -5);
        Time notBefore = new Time(date.getTime());
        date.add(12, 5);
        date.add(13, 1000000);
        Time notAfter = new Time(date.getTime());
        validity.setNotBefore(notBefore);
        validity.setNotAfter(notAfter);
        certTemplate.setValidity(validity);
        log.debug("Constructed " + certTemplate.toString());
        return certTemplate;
    }

    private static PKIHeader makePKIHeader(String senderDN, String recipientDN, String senderKID, DEROctetString salt, String owfAlgIdStr, String macAlgIdStr, int iterCountInt, String protectionAlgIdStr) {
        AlgorithmIdentifier owfAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(owfAlgIdStr));
        AlgorithmIdentifier macAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(macAlgIdStr));
        DERInteger iterCount = new DERInteger(iterCountInt);
        PBMParameter params = new PBMParameter(salt, owfAlgId, iterCount, macAlgId);
        AlgorithmIdentifier algId = new AlgorithmIdentifier(new DERObjectIdentifier(protectionAlgIdStr), (DEREncodable)params);
        PKIHeader pkiHeader = new PKIHeader(new DERInteger(2), new GeneralName(new X509Name(senderDN)), new GeneralName(new X509Name(recipientDN)));
        pkiHeader.setSenderKID(new DEROctetString(senderKID.getBytes()));
        pkiHeader.setProtectionAlg(algId);
        return pkiHeader;
    }

    private static byte[] makeProtection(String secret, int iterCount, String owfAlgId, String macAlgId, DEROctetString salt, PKIMessage message) {
        int i;
        byte[] saltBytes = salt.getOctets();
        byte[] sharedSecret = secret.getBytes();
        byte[] firstKey = new byte[sharedSecret.length + saltBytes.length];
        for (i = 0; i < sharedSecret.length; ++i) {
            firstKey[i] = sharedSecret[i];
        }
        for (i = 0; i < saltBytes.length; ++i) {
            firstKey[sharedSecret.length + i] = saltBytes[i];
        }
        MessageDigest dig = null;
        Mac mac = null;
        try {
            dig = MessageDigest.getInstance(owfAlgId, "BC");
            for (int i2 = 0; i2 < iterCount; ++i2) {
                firstKey = dig.digest(firstKey);
                dig.reset();
            }
            mac = Mac.getInstance(macAlgId, "BC");
            SecretKeySpec key = new SecretKeySpec(firstKey, macAlgId);
            mac.init(key);
        }
        catch (Exception e) {
            log.error("Error while calculating PKIMessage protection", (Throwable)e);
        }
        mac.reset();
        byte[] protectedBytes = message.getProtectedBytes();
        mac.update(protectedBytes, 0, protectedBytes.length);
        return mac.doFinal();
    }

    private static int makeRandomInt(int digits) {
        SecureRandom random = new SecureRandom();
        return random.nextInt(digits);
    }
}

