/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.x509;

import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Extension;

public class CertificateExtension {
    private DERObjectIdentifier oid_ = null;
    private X509Extension extension_ = null;
    private boolean critical_ = false;
    private String name_ = null;
    private String value_ = null;

    protected CertificateExtension(DERObjectIdentifier oid, String name, X509Extension extension, String value) {
        this(oid, name, extension, value, false);
    }

    protected CertificateExtension(DERObjectIdentifier oid, X509Extension extension, boolean critical) {
        this(oid, oid.getId(), extension, "NotParsed", critical);
    }

    protected CertificateExtension(DERObjectIdentifier oid, String name, X509Extension extension, String value, boolean critical) {
        this.oid_ = oid;
        this.extension_ = extension;
        this.critical_ = critical;
        this.name_ = name;
        this.value_ = value;
    }

    public X509Extension getExtension() {
        return this.extension_;
    }

    public DERObjectIdentifier getOID() {
        return this.oid_;
    }

    public boolean isCritical() {
        return this.critical_;
    }

    public String getName() {
        return this.name_;
    }

    public String getValue() {
        return this.value_;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.critical_ ? 1231 : 1237);
        result = 31 * result + (this.extension_ == null ? 0 : this.extension_.hashCode());
        result = 31 * result + (this.oid_ == null ? 0 : this.oid_.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertificateExtension other = (CertificateExtension)obj;
        if (this.critical_ != other.critical_) {
            return false;
        }
        if (this.extension_ == null ? other.extension_ != null : !this.extension_.equals((Object)other.extension_)) {
            return false;
        }
        return !(this.oid_ == null ? other.oid_ != null : !this.oid_.equals((Object)other.oid_));
    }
}

